% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cof_ehv_cables.R
\name{environmental_cof_ehv_cables}
\alias{environmental_cof_ehv_cables}
\title{Environmental cost of Failure for EHV UG cables & 132 kV UG cables}
\source{
DNO Common Network Asset Indices Methodology (CNAIM),
Health & Criticality - Version 2.1, 2021:
\url{https://www.ofgem.gov.uk/sites/default/files/docs/2021/04/dno_common_network_asset_indices_methodology_v2.1_final_01-04-2021.pdf}
}
\usage{
environmental_cof_ehv_cables(ehv_asset_category, prox_water, bunded)
}
\arguments{
\item{ehv_asset_category}{String The type of EHV cable distribution asset category
Options: \code{ehv_asset_category =
c("33kV UG Cable (Oil)", "33kV UG Cable (Gas)", "33kV UG Cable (Non Pressurised)",
"66kV UG Cable (Oil)", "66kV UG Cable (Gas)", "66kV UG Cable (Non Pressurised)",
"132kV UG Cable (Oil)", "132kV UG Cable (Gas)", "132kV UG Cable (Non Pressurised)")}.}

\item{prox_water}{Numeric. Specify the proximity to a water course in meters.
A setting of \code{"Default"} will result in a proximity factor of 1. Thus
assume the proximity to a water course is between 80m and 120m
(cf. table 231, page 188, CNAIM, 2021).}

\item{bunded}{String. Options: \code{bunded = c("Yes", "No", "Default")}.
A setting of \code{"Default"} will result in a bunding factor of 1.}
}
\description{
This function calculates environmental consequences of failure
(cf. section 7.3, page 79, CNAIM, 2021). Environmental consequences
of failure is used in
the derivation of consequences of failure see \code{\link{cof}}().#' @return Numeric. Financial consequences of failure for LV switchgear
}
\examples{
environmental_cof_ehv_cables(ehv_asset_category = "33kV UG Cable (Oil)",
prox_water = 95, bunded = "Yes")
}
