% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convrg_func.R
\name{extract_point_estimate}
\alias{extract_point_estimate}
\title{@encoding UTF-8
Extract point estimates of pi parameters}
\usage{
extract_point_estimate(modelOut, countData, treatments)
}
\arguments{
\item{modelOut}{Fitted Stan object}

\item{countData}{The count data modelled. Must be in exactly the same format.}

\item{treatments}{An integer describing how many treatment groups were modelled.}
}
\value{
A dataframe specifying point estimates for each feature in each treatment group.
}
\description{
Takes the mean value of pi parameters for each feature and separately by treatment group.
}
\examples{
com_demo <-matrix(0, nrow = 10, ncol = 10)
com_demo[1:5,] <- c(rep(3,5), rep(7,5)) #Alternates 3 and 7
com_demo[6:10,] <- c(rep(7,5), rep(3,5)) #Reverses alternation
out <- varInf(com_demo,starts = c(1,6), ends=c(5,10))
extract_point_estimate(modelOut = out, countData = com_demo, treatments = 2)
}
