% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getBlockAverageMatrixFromBreakpoints.R
\name{getBlockAverageMatrixFromBreakpoints}
\alias{getBlockAverageMatrixFromBreakpoints}
\title{Calculate block averages and areas in a matrix given breakpoints.}
\arguments{
\item{whole_matrix}{the large, whole matrix from which blocks are taken}

\item{breakpoints_col}{An integer list of column breakpoints, including 1 and the number of columns in the whole matrix.}

\item{breakpoints_row}{An integer list of row breakpoints, including 1 and the number of rows in the whole matrix.}

\item{outputs}{A list of the following possible outputs (default all): "blockaverages_reformatted_by_index","blockaverages_reformatted_by_label","blockaverages_matrix_idx_area","blockaverages_matrix_idx_avg","blockaverages_matrix_label_avg", or "blockaverages_matrix_label_area"}
}
\value{
An output list of the following:

blockaverages_reformatted_by_index  a matrix of the block averages and areas, in long format, with indexes used to generate the averages.

blockaverages_reformatted_by_label a matrix of the block averages and areas, in long format, with labels of the indexes used to generate the averages.

blockaverages_matrix_idx_area a matrix of the block areas, with indexes based on the original row/col index used to generate the data.

blockaverages_matrix_idx_avg a matrix of the block averages, with indexes based on the original row/col index used to generate the data.

blockaverages_matrix_label_area a matrix of the block areas, with indexes based on the original row/col label used to generate the data.

blockaverages_matrix_label_avg a matrix of the block averages, with indexes based on the original row/col label used to generate the data.
}
\description{
This function produces several matrix outputs of averages and areas of matrix blocks, given a pair of vectors for breakpoints.
}
\examples{
load(system.file("extdata","nbl_result_matrix_sign_small.rda",package = "CNVScope"))
set.seed(303)
mat<-matrix(data=runif(n = 25),nrow=5,ncol=5,dimnames = list(c("chr1_0_5000",
"chr1_5000_10000","chr1_10000_15000","chr1_15000_20000","chr1_20000_25000"),
c("chr1_0_5000","chr1_5000_10000","chr1_10000_15000","chr1_15000_20000","chr1_20000_25000")))
breakpoints_col<-c(1,2,4,5)
breakpoints_row<-c(1,2,4,5)
foreach::registerDoSEQ()
getBlockAverageMatrixFromBreakpoints(whole_matrix=mat,breakpoints_col=breakpoints_col,
breakpoints_row=breakpoints_row)
\dontrun{ #extra examples
mat<-matrix(data=round(runif(min = 0,max=100,n = 25)),nrow=5,ncol=5,
dimnames = list(c("chr1_0_5000","chr1_5000_10000","chr1_10000_15000","chr1_15000_20000",
"chr1_20000_25000"),c("chr2_0_50000","chr2_50000_100000",
"chr2_100000_150000","chr2_150000_200000","chr2_200000_250000")))
breakpoints_col<-c(1,2,4,5)
breakpoints_row<-c(1,2,4,5)
avg_results<-getBlockAverageMatrixFromBreakpoints(whole_matrix=mat,
breakpoints_col=breakpoints_col,breakpoints_row=breakpoints_row)
avg_results$blockaverages_reformatted_by_label
avg_results$blockaverages_reformatted_by_index
whole_matrix=mat
mat<-matrix(data=round(runif(min = 0,max=100,n = 25)),nrow=5,ncol=5,
dimnames = list(c("chr1_0_5000","chr1_5000_10000","chr1_10000_15000",
"chr1_15000_20000","chr1_20000_25000"),c("chr2_0_50000",
"chr2_50000_100000","chr2_100000_150000",
"chr2_150000_200000","chr2_200000_250000")))
breakpoints_col<-c(1,2,4,5)
breakpoints_row<-c(1,2,4,5)
avg_results<-getBlockAverageMatrixFromBreakpoints(whole_matrix=mat,
breakpoints_col=breakpoints_col,breakpoints_row=breakpoints_row)
avg_results$blockaverages_reformatted_by_label
avg_results$blockaverages_reformatted_by_index
whole_matrix=mat
submatrix<-nbl_result_matrix_sign_small
breakpoints_row_jointseg<-jointseg::jointSeg(submatrix,K=5)$bestBkp
breakpoints_col_jointseg<-jointseg::jointSeg(t(submatrix),K=5)$bestBkp
submatrix_avg_results<-getBlockAverageMatrixFromBreakpoints(whole_matrix=submatrix,
breakpoints_col=breakpoints_col_jointseg,breakpoints_row=breakpoints_row_jointseg)
}
}
\keyword{CNV}
\keyword{concordance}
\keyword{distribution}
\keyword{fast}
\keyword{kernel}
\keyword{probability}
