% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{RR_COAP}
\alias{RR_COAP}
\title{Fit the COAP model}
\usage{
RR_COAP(
  X_count,
  multiFac = rep(1, nrow(X_count)),
  Z = matrix(1, nrow(X_count), 1),
  rank_use = 5,
  q = 15,
  epsELBO = 1e-05,
  maxIter = 30,
  verbose = TRUE,
  joint_opt_beta = FALSE,
  fast_svd = TRUE
)
}
\arguments{
\item{X_count}{a count matrix, the observed count matrix.}

\item{multiFac}{an optional vector, the normalization factor for each unit; default as full-one vector.}

\item{Z}{an optional matrix, the covariate matrix; default as a full-one column vector if there is no additional covariates.}

\item{rank_use}{an optional integer, specify the rank of the regression coefficient matrix; default as 5.}

\item{q}{an optional string, specify the number of factors; default as 15.}

\item{epsELBO}{an optional positive vlaue, tolerance of relative variation rate of the envidence lower bound value, defualt as '1e-5'.}

\item{maxIter}{the maximum iteration of the VEM algorithm. The default is 30.}

\item{verbose}{a logical value, whether output the information in iteration.}

\item{joint_opt_beta}{a logical value, whether use the joint optimization method to update bbeta. The default is \code{FALSE}, which means using the separate optimization method.}

\item{fast_svd}{a logical value, whether use the fast SVD algorithm in the update of bbeta; default is \code{TRUE}.}
}
\value{
return a list including the following components: (1) H, the predicted factor matrix; (2) B, the estimated loading matrix; (3) bbeta, the estimated low-rank large coefficient matrix; (4) invLambda, the inverse of the estimated variances of error; (5) H0, the factor matrix; (6) ELBO: the ELBO value when algorithm stops; (7) ELBO_seq: the sequence of ELBO values.
}
\description{
Fit the covariate-augmented overdispersed Poisson factor model
}
\details{
None
}
\examples{
n <- 300; p <- 100
d <- 20; q <- 6; r <- 3
datlist <- gendata_simu(n=n, p=p, d=20, q=q, rank0=r)
str(datlist)
fitlist <- RR_COAP(X_count=datlist$X, Z = datlist$Z, q=6, rank_use=3)
str(fitlist)
}
\references{
Liu, W. and Q. Zhong (2024). High-dimensional covariate-augmented overdispersed poisson factor model. arXiv preprint arXiv:2402.15071.
}
\seealso{
None
}
