% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coin_aggregate.R
\name{aggregate}
\alias{aggregate}
\title{Aggregate indicators}
\usage{
aggregate(
  COIN,
  agtype = "arith_mean",
  agweights = NULL,
  dset = NULL,
  agtype_bylevel = NULL,
  agfunc = NULL,
  avail_limit = NULL,
  out2 = NULL
)
}
\arguments{
\item{COIN}{COIN object}

\item{agtype}{The type of aggregation method. One of either:
\itemize{
\item \code{"arith_mean"} - weighted arithmetic mean
\item \code{"median"} - weighted median
\item \code{"geom_mean"} - weighted geometric mean
\item \code{"harm_mean"} - weighted harmonic mean
\item \code{"copeland"} - weighted Copeland method
\item \code{"custom"} - a custom function -  see \code{agfunc}
\item \code{"mixed"} - a different aggregation method for each level. In this case, aggregation methods are specified as any of the previous
options using the \code{agtype_bylevel} argument.
}}

\item{agweights}{The weights to use in the aggregation. This can either be:
\code{NULL}, in which case it will use the weights that were attached to \code{IndMeta} and \code{AggMeta} in \code{\link[=assemble]{assemble()}} (if they exist), or
A character string which corresponds to a named list of weights stored in \code{.$Parameters$Weights}. You can either add these manually or through \code{\link[=rew8r]{rew8r()}}.
E.g. entering \code{agweights = "Original"} will use the original weights read in on assembly. This is equivalent to \code{agweights = NULL}.
Or, a data frame of weights to use in the aggregation.}

\item{dset}{Which data set (contained in COIN object) to use}

\item{agtype_bylevel}{A character vector with aggregation types for each level. Note that if this is specified, \code{agtype} \emph{must}
be specified as \code{agtype = "mixed"}, otherwise \code{agtype_by_level} will be ignored.}

\item{agfunc}{A custom function to use for aggregation if \code{agtype = "custom"}, of the type \eqn{y = f(x,w)},
where \eqn{y} is a scalar aggregated value and \eqn{x} and \eqn{w} are vectors of indicator values and weights respectively.
Ensure that \code{NA}s are handled (e.g. set \code{na.rm = T}) if your data has missing values.}

\item{avail_limit}{A data availability threshold, below which aggregation returns NA. This parameter is the fraction of data
availability needed in a given aggregation group to return an aggregated score. Specified as either \code{NULL} (default, aggregation
values are always returned if possible) or a value between 0 and 1 (below this value of data availability, \code{NA} will be
returned). See Details.
are ignored during aggregation, so that as long as there is at least one value in an aggregation group}

\item{out2}{Where to output the results. If \code{"COIN"} (default for COIN input), appends to updated COIN,
otherwise if \code{"df"} outputs to data frame.}
}
\value{
An updated COIN containing the new aggregated data set at \code{.$Data$Aggregated}.
}
\description{
Takes indicator data and a specified structure and hierarchically aggregates according to the structure
specified in \code{IndMeta}. Uses a variety of aggregation methods as specified by \code{agtype}, which can be different for
each level of aggregation (see \code{agtype_by_level}).
}
\details{
This function aggregates indicators according to the index structure specified in \code{IndMeta}. It will either use a single
aggregation method for all aggregation levels (by specifying \code{agtype}) or can use a different aggregation method for each
level of the index (see \code{agtype_by_level}). Aggregation methods are typically weighted (e.g. weighted means), and the weights
for the aggregation are specified using the \code{agweights} argument.

By default, this function will aggregate wherever possible - generally this means that if at least one value is available
for a given unit inside an aggregation group, it will return an aggregated score. Optionally, you can also specify a data
availability threshold which will instead return \code{NA} if the data availability (within group and for each unit) falls below
the threshold. For example, you may have four indicators inside a group, and you might want to only produce an aggregated
score if data availability is at least 50\% - this would be specified by \code{avail_limit = 0.5}. It is also possible to specify
different data availability thresholds for different levels of the index, by specifying \code{avail_limit} as a vector which has
one value for every aggregation level (the first value gives the threshold for the first aggregation, and so on up to the
final level).
}
\examples{
# assemble a COIN first
ASEM <- assemble(IndData = ASEMIndData, IndMeta = ASEMIndMeta, AggMeta = ASEMAggMeta)
# normalise the data
ASEM <- normalise(ASEM, dset = "Raw")
# aggregate the data
ASEM <- COINr::aggregate(ASEM, agtype="arith_mean", dset = "Normalised")
# check aggregated data set exists
stopifnot(!is.null(ASEM$Data$Aggregated))

}
