% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coin_multivariate.R
\name{getCronbach}
\alias{getCronbach}
\title{Cronbach's alpha}
\usage{
getCronbach(
  COIN,
  dset = "Raw",
  icodes = NULL,
  aglev = NULL,
  use = "pairwise.complete.obs"
)
}
\arguments{
\item{COIN}{A COIN or a data frame containing only numerical columns of data.}

\item{dset}{The data set to check the consistency of.}

\item{icodes}{Indicator codes if a subset of \code{dset} is requested}

\item{aglev}{The aggregation level to take \code{icodes} from (see \code{\link[=getIn]{getIn()}} for details)}

\item{use}{Argument to pass to \link[stats:cor]{stats::cor} to calculate the covariance matrix. Default \code{"pairwise.complete.obs"}.}
}
\value{
Cronbach alpha as a numerical value.
}
\description{
Calculates Cronbach's alpha, a measure of statistical reliability. Cronbach's alpha is a simple measure
of "consistency" of a data set, where a high value implies higher reliability/consistency.
}
\details{
This function simply returns Cronbach's alpha. If you want a lot more details on reliability, the 'psych' package has
a much more detailed analysis.
}
\examples{
# build ASEM COIN
ASEM <- assemble(IndData = ASEMIndData, IndMeta = ASEMIndMeta, AggMeta = ASEMAggMeta)
# get Cronbach of indicators in Physical pillar
getCronbach(ASEM, dset = "Raw", icodes = "Physical", aglev = 1)

}
