% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coin_resultsdash.R
\name{iplotMap}
\alias{iplotMap}
\title{Choropleth map}
\usage{
iplotMap(COIN, dset = "Raw", isel)
}
\arguments{
\item{COIN}{The COIN object, or a data frame of indicator data.}

\item{dset}{The data set to plot.}

\item{isel}{The selected indicator code or aggregate}
}
\value{
Interactive map generated by plotly.
}
\description{
Generates an interactive choropleth map of specified indicator data. Only works on national
level data (i.e. one point per country), with countries labelled by \href{https://www.iso.org/iso-3166-country-codes.html}{ISO alpha-3 codes}.
This function is simply a quick wrapper for the \strong{plotly} choropleth map function.
}
\examples{
# assemble ASEM COIN
ASEM <- assemble(IndData = ASEMIndData, IndMeta = ASEMIndMeta, AggMeta = ASEMAggMeta)
# map CO2 indicator
iplotMap(ASEM, dset = "Raw", isel = "CO2")

}
\seealso{
\itemize{
\item \code{\link[=iplotBar]{iplotBar()}} bar chart of indicator or aggregate
\item \code{\link[=resultsDash]{resultsDash()}} interactive dashboard of indicator data
}
}
