% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coin_sensitivity.R
\name{sensitivity}
\alias{sensitivity}
\title{Sensitivity analysis}
\usage{
sensitivity(
  COIN,
  v_targ,
  SA_specs,
  N,
  SA_type = "UA",
  NrepWeights = 1000,
  store_results = "results+params",
  Nboot = NULL,
  quietly = FALSE
)
}
\arguments{
\item{COIN}{A COIN (this function does not support data frame input)}

\item{v_targ}{The target variable to perform SA or UA on. Currently just supports one variable, which
should be an indicator/aggregate code present in \code{.$Data$Aggregated}.}

\item{SA_specs}{A list which specifies which variables to perturb, and which alternatives/distributions to use}

\item{N}{The number of Monte Carlo replications.}

\item{SA_type}{The type of analysis to run. \code{"UA"} runs an uncertainty analysis. \code{"SA"} runs a sensitivity analysis (which anyway includes an uncertainty analysis).}

\item{NrepWeights}{The number of weight-replications to generate. Default 1000.}

\item{store_results}{Which results to store
\itemize{
\item \code{"onlyresults"} only stores scores, ranks and rank statistics (e.g. mean, median, quantiles)
\item \code{"results+params"} (default) stores all of the above, plus a record of the parameter values used for each replication
\item \code{"results+method"} stores all of the above, plus the full \code{.$Method} list of each replication
\item \code{"results+COIN"} stores all results and the complete COIN of each replication (this could result in a very large list).
}}

\item{Nboot}{Number of bootstrap draws for estimates of confidence intervals on sensitivity indices.
If this is not specified, bootstrapping is not applied. Ignored if \code{SA_type = "UA"}.}

\item{quietly}{If \code{FALSE} (default), gives progress messages. Set \code{TRUE} to suppress these.}
}
\value{
Sensitivity analysis results as a list, containing:
\itemize{
\item \code{.$Scores} a data frame with a row for each unit, and columns are the scores for each replication.
\item \code{.$Parameters} a record of the parameters used for each iteration
\item \code{.$Ranks} as \code{.$Scores} but for unit ranks
\item \code{.$RankStats} summary statistics for ranks of each unit
\item \code{.$Nominal} the nominal scores and ranks of each unit (i.e. from the original COIN)
\item Some information on the time elapsed, average time, and the parameters perturbed.
\item Depending on the setting of \code{store_results}, may also contain a list of Methods or a list of COINs for each replication.
}
}
\description{
Performs global uncertainty and sensitivity analysis on a COIN.
}
\details{
To perform a sensitivity or uncertainty analysis, you must specify \emph{which} parameters/assumptions to vary and \emph{what} their alternative
values are. This is the \code{SA_specs} argument below. To understand how this works, please see the \href{https://bluefoxr.github.io/COINrDoc/sensitivity-analysis.html#sensitivity-in-coinr}{COINr online documentation}.

The output of this function can be visualised with the functions \code{\link[=plotSARanks]{plotSARanks()}} and \code{\link[=plotSA]{plotSA()}}.
}
\examples{
\donttest{
# build ASEM COIN up to aggregation
ASEM <- build_ASEM()

# define noise to be applied to weights
nspecs <- data.frame(AgLevel = c(2,3), NoiseFactor = c(0.25,0.25))

# create list specifying assumptions to vary and alternatives
SAspecs <- list(
  impute = list(imtype = c("indgroup_mean", "ind_mean", "none")),
  normalise = list(ntype = c("minmax", "rank", "dist2max")),
  weights = list(NoiseSpecs = nspecs, Nominal = "Original")
)

# run uncertainty analysis
# here we set N deliberately much lower than normal to enable quick testing
# Would recommend in a practical case to increase to perhaps 500 (more is always better)
SAresults <- sensitivity(ASEM, v_targ = "Index",
                         SA_specs = SAspecs,
                         N = 15,
                         SA_type = "UA")

# to run a sensitivity analysis set SA_type = "SA" (takes longer)
}

}
\seealso{
\itemize{
\item \code{\link[=plotSARanks]{plotSARanks()}} Plot confidence intervals of ranks following UA or SA
\item \code{\link[=plotSA]{plotSA()}} Plot sensitivity indices following a sensitivity analysis
}
}
