% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlations.R
\name{get_cronbach}
\alias{get_cronbach}
\title{Cronbach's alpha}
\usage{
get_cronbach(coin, dset, iCodes, Level, ..., use = "pairwise.complete.obs")
}
\arguments{
\item{coin}{A coin or a data frame containing only numerical columns of data.}

\item{dset}{The name of the data set to apply the function to, which should be accessible in \code{.$Data}.}

\item{iCodes}{Indicator codes to retrieve. If \code{NULL} (default), returns all iCodes found in
the selected data set. See \code{\link[=get_data]{get_data()}}.}

\item{Level}{The level in the hierarchy to extract data from. See \code{\link[=get_data]{get_data()}}.}

\item{...}{Further arguments passed to \code{\link[=get_data]{get_data()}}, other than those explicitly specified here.}

\item{use}{Argument to pass to \link[stats:cor]{stats::cor} to calculate the covariance matrix. Default \code{"pairwise.complete.obs"}.}
}
\value{
Cronbach alpha as a numerical value.
}
\description{
Calculates Cronbach's alpha, a measure of statistical reliability. Cronbach's alpha is a simple measure
of "consistency" of a data set, where a high value implies higher reliability/consistency. The
selection of indicators via \code{\link[=get_data]{get_data()}} allows to calculate the measure on any group of
indicators or aggregates.
}
\details{
This function simply returns Cronbach's alpha. If you want a lot more details on reliability, the 'psych' package has
a much more detailed analysis.
}
\examples{
# build example coin
coin <- build_example_coin(up_to = "new_coin", quietly = TRUE)

# Cronbach's alpha for the "P2P" group
get_cronbach(coin, dset = "Raw", iCodes = "P2P", Level = 1)

}
