% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qfuncs.R
\name{qTreat.data.frame}
\alias{qTreat.data.frame}
\title{Quick outlier treatment of a data frame}
\usage{
\method{qTreat}{data.frame}(x, winmax = 5, skew_thresh = 2, kurt_thresh = 3.5, f2 = "log_CT", ...)
}
\arguments{
\item{x}{A numeric data frame}

\item{winmax}{Maximum number of points to Winsorise for each column. Default 5.}

\item{skew_thresh}{Absolute skew threshold - default 2.}

\item{kurt_thresh}{Kurtosis threshold - default 3.5.}

\item{f2}{Function to call if Winsorisation does not bring skew and kurtosis within limits. Default \code{"log_CT"}.}

\item{...}{arguments passed to or from other methods.}
}
\value{
A list
}
\description{
A simplified version of \code{\link[=Treat]{Treat()}} which allows direct access to the default parameters. This has less flexibility,
but is an easier interface and probably more convenient if the objective is to use the default treatment process
but with some minor adjustments.
}
\details{
This function treats each column in \code{x} using the following process:
\itemize{
\item First, it checks whether skew and kurtosis are within the specified limits of \code{skew_thresh} and \code{kurt_thresh}
\item If the column is not within the limits, it applies the \code{\link[=winsorise]{winsorise()}} function, with maximum number of winsorised
points specified by \code{winmax}.
\item If winsorisation does not bring the column within the skew/kurtosis limits, it is instead passed to \code{f2}, which is
a second outlier treatment function, default \code{\link[=log_CT]{log_CT()}}.
}

The arguments of \code{\link[=qTreat]{qTreat()}} are passed to \code{\link[=Treat]{Treat()}}.

See \code{\link[=Treat]{Treat()}} documentation for more details, and \code{vignette("treat")}.
}
\examples{
# select three indicators
df1 <- ASEM_iData[c("Flights", "Goods", "Services")]

# treat data frame, changing winmax and skew/kurtosis limits
l_treat <- qTreat(df1, winmax = 1, skew_thresh = 1.5, kurt_thresh = 3)

# Now we check what the results are:
l_treat$Dets_Table

}
