% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate.R
\name{a_copeland}
\alias{a_copeland}
\title{Copeland scores}
\usage{
a_copeland(X, w = NULL)
}
\arguments{
\item{X}{A numeric data frame or matrix of indicator data, with observations as rows and indicators
as columns. No other columns should be present (e.g. label columns).}

\item{w}{A numeric vector of weights, which should have length equal to \code{ncol(X)}. Weights are relative
and will be re-scaled to sum to 1. If \code{w} is not specified, defaults to equal weights.}
}
\value{
Numeric vector of Copeland scores.
}
\description{
Aggregates a data frame of indicator values into a single column using the Copeland method.
This function calls \code{outrankMatrix()}.
}
\details{
The outranking matrix is transformed as follows:
\itemize{
\item values > 0.5 are replaced by 1
\item values < 0.5 are replaced by -1
\item values == 0.5 are replaced by 0
\item the diagonal of the matrix is all zeros
}

The Copeland scores are calculated as the row sums of this transformed matrix.

This function replaces the now-defunct \code{copeland()} from COINr < v1.0.
}
\examples{
# some example data
ind_data <- COINr::ASEM_iData[12:16]

# aggregate with vector of weights
outlist <- outrankMatrix(ind_data)

}
