% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misclassification_prob2.R
\name{misclassification_prob2}
\alias{misclassification_prob2}
\title{Compute Conditional Probability of Each Second-Stage Observed Outcome Given Each True Outcome and First-Stage Observed Outcome, for Every Subject}
\usage{
misclassification_prob2(gamma2_array, z2_matrix)
}
\arguments{
\item{gamma2_array}{A numeric array of estimated regression parameters for the
observation mechanism, \eqn{Y^{*(2)}| Y^{*(1)}, Y} (second-stage observed outcome,
given the first-stage observed outcome and the true outcome)
~ \eqn{Z^{(2)}} (second-stage misclassification predictor matrix). Rows of the array
correspond to parameters for the \eqn{Y^{*(2)} = 1} observed outcome, with the
dimensions of \code{z2_matrix}. Columns of the array correspond to the first-stage
outcome categories \eqn{k = 1, \dots,} \code{n_cat}. The third stage of the array
corresponds to the true outcome categories \eqn{j = 1, \dots,} \code{n_cat}.
The array should be obtained by \code{COMBO_EM} or \code{COMBO_MCMC}.}

\item{z2_matrix}{A numeric matrix of covariates in the second-stage observation mechanism.
\code{z2_matrix} should not contain an intercept.}
}
\value{
\code{misclassification_prob2} returns a dataframe containing five columns.
The first column, \code{Subject}, represents the subject ID, from \eqn{1} to \code{n},
where \code{n} is the sample size, or equivalently, the number of rows in \code{z2_matrix}.
The second column, \code{Y}, represents a true, latent outcome category \eqn{Y \in \{1, 2 \}}.
The third column, \code{Ystar1}, represents a first-stage observed outcome category \eqn{Y^{*(1)} \in \{1, 2 \}}.
The fourth column, \code{Ystar2}, represents a second-stage observed outcome category \eqn{Y^{*(2)}  \in \{1, 2 \}}.
The last column, \code{Probability}, is the value of the equation
\eqn{\frac{\text{exp}\{\gamma^{(2)}_{\ell kj0} + \gamma^{(2)}_{\ell kjZ^{(2)}} Z^{(2)}\}}{1 + \text{exp}\{\gamma^{(2)}_{\ell kj0} + \gamma^{(2)}_{\ell kjZ^{(2)}} Z^{(2)}_i\}}}
computed for each subject, first-stage observed outcome category, second-stage
observed outcome category, and true, latent outcome category.
}
\description{
Compute the conditional probability of observing second-stage outcome \eqn{Y^{*(2)} \in \{1, 2 \}} given
the latent true outcome \eqn{Y \in \{1, 2 \}} and the first-stage outcome \eqn{Y^{*(1)} \in \{1, 2\}} as
\eqn{\frac{\text{exp}\{\gamma^{(2)}_{\ell kj0} + \gamma^{(2)}_{\ell kjZ^{(2)}} Z^{(2)}\}}{1 + \text{exp}\{\gamma^{(2)}_{\ell kj0} + \gamma^{(2)}_{\ell kjZ^{(2)}} Z^{(2)}_i\}}}
for each of the \eqn{i = 1, \dots,} \eqn{n} subjects.
}
\examples{
set.seed(123)
sample_size <- 1000
cov1 <- rnorm(sample_size)
cov2 <- rnorm(sample_size, 1, 2)
z2_matrix <- matrix(c(cov1, cov2), nrow = sample_size, byrow = FALSE)
estimated_gamma2 <- array(c(1, -1, .5, .2, -.6, 1.5,
                            -1, .5, -1, -.5, -1, -.5), dim = c(3,2,2))
P_Ystar2_Ystar1_Y <- misclassification_prob2(estimated_gamma2, z2_matrix)
head(P_Ystar2_Ystar1_Y)
}
