% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CONDOP.R
\name{select.pops}
\alias{select.pops}
\title{Define a set of gene pairs POPs with an "operon status" to (re)define represent used to train the operon classifier.}
\usage{
select.pops(OPs, NOPs, genes.and.operons, transcCDSs, transcIGRs.pos,
  transcIGRs.neg, minExprCDS = 0.1, minExprIGR = 0.25, maxLenIGR = 150,
  POSSs, POESs, max.start.transc, max.end.transc, wseq, verbose = TRUE, ...)
}
\arguments{
\item{OPs}{Data table including the confirmed operon pairs (OPs). See \code{select.ops}.}

\item{genes.and.operons}{Data table merging gene(s) and operon(s) annotations. See \code{join.genes.and.operons}.}

\item{transcCDSs}{Transcription levels for the coding regions. See \code{comp.gene.transc.levels}.}

\item{transcIGRs.pos}{Transcription levels for the intergenic regions (forard strand). See \code{comp.igr.transc.levels}.}

\item{transcIGRs.neg}{Transcription levels for the intergenic regions (reverse strand). See \code{comp.igr.transc.levels}.}

\item{minExprCDS}{Minimum expression level for the coding sequence regions (CDSs). Default values is 0.1.}

\item{minExprIGR}{Minimum expression level for the intergenic regions (IGRs). Default values is 0.25.}

\item{maxLenIGR}{Maximum length for the intergenic regions (IGRs). Default values is 150.}

\item{POSSs}{Data table representing a set of putative operon start-points.}

\item{POESs}{Data table representing a set of putative operon end-points.}

\item{max.start.transc}{Cutoff values for the start transcription points. Default values is 0.1.}

\item{max.end.transc}{Cutoff values for the end transcription points. Default values is 0.1.}

\item{wseq}{Sequence genome.}

\item{verbose}{Default logical value is TRUE.}

\item{OPs}{Data table including the confirmed non-operon pairs (NOPs). See \code{select.nops}.}
}
\description{
Internal function to build a data table containing gene pairs and the correspoding transcriptomic/genomic feature values. 
The operon classifier trained/validated on the OPs and NOPs is used to predict the operon status of these gene pairs.
}
\author{
Vittorio Fortino
select.pops()
}
\keyword{internal}

