% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ineokm.R
\name{ineokm}
\alias{ineokm}
\title{Interval neokm clustering.}
\usage{
ineokm(x, centers, alpha = 0.3, beta = 0.05, nstart = 10, trace = FALSE,
  iter.max = 20)
}
\arguments{
\item{x}{An 3D interval array.}

\item{centers}{A number or interval, number of cluster for clustering or pre init centers.}

\item{alpha}{A number (overlap).}

\item{beta}{A number (non-exhaustiveness).}

\item{nstart}{A number, number of execution to find the best result.}

\item{trace}{A boolean, tracing information on the progress of the algorithm is produced.}

\item{iter.max}{the maximum number of iterations allowed.}
}
\description{
Culster interval data with neokm algorithm.
}
\examples{
ineokm(iaggregate(iris, col=5), 3)
ineokm(iaggregate(iris, col=5), iaggregate(iris, col=5), 1, 2)
}
