\name{GenerateDataFrame}

\alias{GenerateDataFrame}

\title{
 Generating Data Frame
}

\description{
 Generates a data frame for conditional power calculations.
}

\usage{
 GenerateDataFrame()
}

\details{
 This function generates a data frame for
 testing the conditional power calculating functions.
 
 Its data is generated by random in the following way:
 
 The number of all patients is a realization of
 a Poisson distributed random variable with parameter 200.
 
 The probability of censoring is a realization of
 a uniform distributed random variable of the interval from 0.4 to 0.6,
 one random variable for each of the two groups 'A' and 'B'.
 
 The patients are randomized to group 'A' or 'B'
 each with probability 0.5.
 
 The status (1 = event, 0 = censored) is a realization of
 a Bernoulli random variable with parameter (1 - probability of being censored).
 
 The event time is a realization of
 an exponential random variable
 with parameter (1 - probability of being censored). 
}

\value{
 This function returns a data frame consisting of three columns:
 the group ('A' or 'B') in the first ('group'),
 the status (o or 1) in the second ('stat')
 and the event time in the third column ('time').
}

\note{
 Of course, this is only one and also a quiet simple way of
 generating data frames for interim analysis.
 Such a generated data frame should be more an aid to get to know
 the conditional power caluclating functions
 than simulating realistic data. 
}

\author{
 Andreas Kuehnapfel
}

\seealso{
 \code{\link{CP}} \cr
 \code{\link{test}}
}

\examples{
 # generate a data frame
 data <- GenerateDataFrame()
}