% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/congruent.models.R
\name{congruent.models}
\alias{congruent.models}
\title{Create a set of congruent models}
\usage{
congruent.models(
  model,
  mus = NULL,
  lambdas = NULL,
  keep_ref = TRUE,
  ode_solver = TRUE
)
}
\arguments{
\item{model}{The reference model. An object of class "CRABS"}

\item{mus}{A list of extinction-rate functions}

\item{lambdas}{A list of speciation-rate functions}

\item{keep_ref}{Whether or not to keep the reference model in the congruent set}

\item{ode_solver}{Whether to use a numerical ODE solver to solve for lambda}
}
\value{
An object of class "CRABSset"
}
\description{
Create a set of congruent models
}
\examples{

data(primates_ebd)
lambda <- approxfun(primates_ebd$time, primates_ebd$lambda)
mu <- approxfun(primates_ebd$time, primates_ebd$mu)

## A reference model
times <- seq(0, max(primates_ebd$time), length.out = 500)
model <- create.model(lambda, mu, times = times)

mu1 <- lapply(c(0.5, 1.5, 3.0), function(m) function(t) m)

model_set1 <- congruent.models(model, mus = mu1)

model_set1

lambda0 <- lambda(0.0) ## Speciation rates must all be equal at the present
bs <- c(0.0, 0.01, 0.02)
lambda1 <- lapply(bs, function(b) function(t) lambda0 + b*t)

model_set2 <- congruent.models(model, lambdas = lambda1)

model_set2
}
