% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.CRABSset.R
\name{print.CRABSset}
\alias{print.CRABSset}
\title{Print method for CRABSset object}
\usage{
\method{print}{CRABSset}(x, ...)
}
\arguments{
\item{x}{an object of class CRABSset}

\item{...}{other arguments}
}
\value{
nothing
}
\description{
Print method for CRABSset object
}
\examples{
data(primates_ebd)
lambda <- approxfun(primates_ebd$time, primates_ebd$lambda)
mu <- approxfun(primates_ebd$time, primates_ebd$mu)
times <- seq(0, max(primates_ebd$time), length.out = 500)

model <- create.model(lambda, mu, times = times)

mus <- list(function(t) 0.2 + exp(0.01*t), 
           function(t) 0.2 + sin(0.35*t) + 0.1*t,
           function(t) 1.0, 
           function(t) 0.5 + 0.2*t)
models <- congruent.models(model, mus = mus)

print(models)
}
