% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample.rates.R
\name{sample.basic.models}
\alias{sample.basic.models}
\title{Samples simple increase/decrease models through time with noise.}
\usage{
sample.basic.models(
  times,
  rate0 = NULL,
  model = "exponential",
  direction = "decrease",
  noisy = TRUE,
  MRF.type = "HSMRF",
  monotonic = FALSE,
  fc.mean = 3,
  rate0.median = 0.1,
  rate0.logsd = 1.17481,
  mrf.sd.scale = 1,
  min.rate = 0,
  max.rate = 10
)
}
\arguments{
\item{times}{the time knots}

\item{rate0}{The rate at present, otherwise drawn randomly.}

\item{model}{"MRF" for pure MRF model, otherwise MRF has a trend of type "exponential","linear", or "episodic<n>"}

\item{direction}{"increase" or "decrease" (measured in past to present)}

\item{noisy}{If FALSE, no MRF noise is added to the trajectory}

\item{MRF.type}{"HSMRF" or "GMRF", type for stochastic noise.}

\item{monotonic}{Whether the curve should be forced to always move in one direction.}

\item{fc.mean}{Determines the average amount of change when drawing from the model.}

\item{rate0.median}{When not specified, rate at present is drawn from a lognormal distribution with this median.}

\item{rate0.logsd}{When not specified, rate at present is drawn from a lognormal distribution with this sd}

\item{mrf.sd.scale}{scale the sd of the mrf process up or down. defaults to 1.0}

\item{min.rate}{The minimum rate (rescaling fone after after drawing rates).}

\item{max.rate}{The maximum rate (rescaling fone after after drawing rates).}
}
\value{
Speciation or extinction rate at a number of timepoints.
}
\description{
Samples simple increase/decrease models through time with noise.
}
\examples{
data("primates_ebd")

l <- approxfun(primates_ebd[["time"]], primates_ebd[["lambda"]])
mu <- approxfun(primates_ebd[["time"]], primates_ebd[["mu"]])
times <- primates_ebd[["time"]]

model <- create.model(l, mu, times)

mus <- sample.basic.models(times = times, 
                               rate0 = 0.05, 
                               "MRF", 
                               MRF.type = "HSMRF", 
                               fc.mean = 2.0, 
                               min.rate = 0.0, 
                               max.rate = 1.0)

model_set <- congruent.models(model, mus = mus)

model_set
}
