% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ch_hydrograph_plot.R
\name{ch_hydrograph_plot}
\alias{ch_hydrograph_plot}
\title{Hydrograph plot}
\usage{
ch_hydrograph_plot(
  flows = NULL,
  precip = NULL,
  prd = NULL,
  winter_shading = FALSE,
  winter_colour = "cyan",
  range_mult_flow = NULL,
  range_mult_precip = 1.5,
  flow_labels = NULL,
  ylabel = NULL,
  precip_label = "Precipitation [mm]",
  leg_pos = NULL,
  leg_box = NULL,
  zero_axis = TRUE
)
}
\arguments{
\item{flows}{data frame of flows to plot}

\item{precip}{data frame of precipitation values to plot}

\item{prd}{period to use in plotting}

\item{winter_shading}{optionally adds a transparent cyan shading for the
December 1st to March 31st period in each year that is plotted. Default is
\code{FALSE}.}

\item{winter_colour}{colour to use in winter shading polygons}

\item{range_mult_flow}{range multiplier for max value in hydrograph. This is 
useful in preventing overlap if precip is also plotted. This value should not 
be less than 1.0, otherwise the values will be
cutoff in the plot.}

\item{range_mult_precip}{range multiplier for max value in precipitation plot (default 1.5)}

\item{flow_labels}{string vector of labels for flow values}

\item{ylabel}{text label for y-axis of the plot (default 'Flow [m^3/s]')}

\item{precip_label}{text label for precipitation y-axis (default 'Precipitation [mm]')}

\item{leg_pos}{string specifying legend placement on plot e.g. \option{topleft},
\option{right}, etc., and is consistent with the legend function options. If \code{NULL}, 
the function will place the legend left, if precip added, on the topleft
otherwise).}

\item{leg_box}{boolean on whether to put legend in an opaque white box
or not. If \code{NULL} (the default), the function will automatically not use a white box
and leave the background of the legend transparent.}

\item{zero_axis}{fixes the y axis to start exactly at zero (default \code{TRUE}). 
By default, R will plot the values with a
small buffer for presentation. Be warned that if this option is set to
TRUE, the minimum value is set to zero without checking if any flow values
are less than zero. This option should not be used for reservoir stage plotting, since
most reservoir stage is typically reported as an elevation.}
}
\value{
Returns \code{TRUE} if the function is executed properly.
}
\description{
Creates a hydrograph plot for simulated, observed, and inflow
hydrograph series, including precipitation if provided. The secondary y axis 
will be used to plot the precip time series.
}
\details{
Assumes that the supplied time series have the same length and
duration in time. If this is not true, then the defined period or period
calculated from the first available flow series will be used to determine
the plotting limits in time. The supplied time series should be in \pkg{xts} format.
Note that a plot title is purposely omitted in order to allow the automatic
generation of plot titles.
}
\examples{
# example with synthetic random data
dd <- seq.Date(as.Date("2010-10-01"), as.Date("2013-09-30"),by = 1)
x <- abs(rnorm(length(dd)))
y <- abs(rnorm(length(dd))) * x
df <- data.frame("Date" = dd, x, y)
myprd <- "2011-10-01/2012-09-30"

precip <- data.frame("Date" = dd," precip" = abs(rnorm(length(dd))) * 10)

# basic hydrograph plot
ch_hydrograph_plot(flows = df, winter_shading = FALSE)

# with different labels and winter shading
ch_hydrograph_plot(flows = df, winter_shading = TRUE,
 flow_labels = c("simulated", "observed"))

# add precipitation, increase the plot ranges to separate flows and precip, and add a legend box
ch_hydrograph_plot(flows = df, precip = precip, range_mult_flow = 1.7, 
range_mult_precip = 2, leg_box = TRUE)

}
\author{
Robert Chlumsky
}
