% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ch_wbt_flow_direction.R
\name{ch_wbt_flow_direction}
\alias{ch_wbt_flow_direction}
\title{Creates flow direction grid file}
\usage{
ch_wbt_flow_direction(fn_dem_ns, fn_flowdir, return_raster = TRUE)
}
\arguments{
\item{fn_dem_ns}{File name of dem with sinks removed.}

\item{fn_flowdir}{File name for flow direction grid to be created.}

\item{return_raster}{Should a raster object be returned?}
}
\value{
If \code{return_raster = TRUE} (the default), the flow direction
grid will be returned as a raster object, in addition to being written to
\option{fn_flowdir}. If \code{return_raster = FALSE}, the output file will still be created
but a \code{NULL} value is returned.
}
\description{
Creates flow direction grid file
}
\examples{
# Only proceed if Whitebox executable is installed
library(whitebox)
if (check_whitebox_binary()){
  library(raster)
  test_raster <- ch_volcano_raster()
  dem_raster_file <- tempfile(fileext = c(".tif"))
  no_sink_raster_file <- tempfile("no_sinks", fileext = c(".tif"))

  # write test raster to file
  writeRaster(test_raster, dem_raster_file, format = "GTiff")

  # remove sinks
  removed_sinks <- ch_wbt_removesinks(dem_raster_file, no_sink_raster_file, method = "fill")

  # get flow directions
  flow_dir_file <- tempfile("flow_dir", fileext = c(".tif"))
  flow_dir <- ch_wbt_flow_direction(no_sink_raster_file, flow_dir_file)
  plot(flow_dir)
} else {
  message("Examples not run as Whitebox executable not found")
}
}
\author{
Dan Moore
}
