% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probcush.R
\name{probcush}
\alias{probcush}
\title{Probability distribution of a CUSH model}
\usage{
probcush(m,delta,shelter)
}
\arguments{
\item{m}{Number of ordinal categories}

\item{delta}{Shelter parameter}

\item{shelter}{Category corresponding to the shelter choice}
}
\value{
The vector of the probability distribution of a CUSH model without covariates
}
\description{
Compute the probability distribution of a CUSH model without covariates.
}
\examples{
m<-10
shelter<-1
delta<-0.4
pr<-probcush(m,delta,shelter)
plot(1:m,pr,type="h",xlab="Number of categories")
points(1:m,pr,pch=19)
}
\references{
Capecchi S. and Piccolo D. (2016). Dealing with heterogeneity in ordinal responses,
 \emph{Quality and Quantity}, DOI: 10.1007/s11135-016-0393-3 \cr
Capecchi S. and Iannario M. (2016). Gini heterogeneity index for detecting uncertainty in ordinal data surveys,
 \emph{Metron}, \bold{74}(2), 223--232
}
\keyword{distribution}

