% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varcovcubeobs.R
\name{varcovcubeobs}
\alias{varcovcubeobs}
\title{Variance-covariance matrix for CUBE models based on the observed information matrix}
\usage{
varcovcubeobs(m, pai, csi, phi, freq)
}
\arguments{
\item{m}{Number of ordinal categories}

\item{pai}{Uncertainty parameter}

\item{csi}{Feeling parameter}

\item{phi}{Overdispersion parameter}

\item{freq}{Vector of the observed absolute frequencies}
}
\description{
Compute the variance-covariance matrix of parameter estimates for a CUBE model without covariates 
as the inverse of the observed information matrix.
}
\details{
The function checks if the variance-covariance matrix is positive-definite: if not, 
it returns a warning message and produces a matrix with NA entries.
}
\references{
Iannario, M. (2014). Modelling Uncertainty and Overdispersion in Ordinal Data, 
\emph{Communications in Statistics - Theory and Methods}, \bold{43}, 771--786
}
\seealso{
\code{\link{varcovcubeexp}}
}
\keyword{internal}
