% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gecubpqs.R
\name{gecubpqs}
\alias{gecubpqs}
\title{Main function for CUB models with covariates for all the components}
\usage{
gecubpqs(ordinal,Y,W,X,shelter,theta0,maxiter,toler)
}
\arguments{
\item{ordinal}{Vector of ordinal responses}

\item{Y}{Matrix of selected covariates for explaining the uncertainty component, not including intercept}

\item{W}{Matrix of selected covariates for explaining the feeling component, not including intercept}

\item{X}{Matrix of selected covariates for explaining the shelter effect, not including intercept}

\item{shelter}{Category corresponding to the shelter choice}

\item{theta0}{Starting values for parameters explaining the shelter effect}

\item{maxiter}{Maximum number of iterations allowed for running the optimization algorithm}

\item{toler}{Fixed error tolerance for final estimates}
}
\value{
An object of the class "CUB"
}
\description{
Function to estimate and validate a CUB model for given ordinal responses, with covariates for
 explaining all the components and the shelter effect.
}
\references{
Piccolo D. and D'Elia A. (2008), A new approach for modelling consumers' preferences,
  \emph{Food Quality and Preference}, \bold{18}, 247--259 \cr

Iannario M. and Piccolo D. (2010), A new statistical model for the analysis of customer
 satisfaction, #' \emph{Quality Technology and Quantity management}, \bold{7}(2) 149--168 \cr
Iannario M. and Piccolo D. (2012), CUB models: Statistical methods and empirical evidence, in:
Kenett R. S. and Salini S. (eds.), \emph{Modern Analysis of Customer Surveys: with applications using R},
 J. Wiley and Sons, Chichester, 231--258.
}
\keyword{internal}
