% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{compute_stat}
\alias{compute_stat}
\title{Computing Score Test Statistics.}
\usage{
compute_stat(Y, K_int, y_fixed, K0, sigma2_hat, tau_hat)
}
\arguments{
\item{Y}{(matrix, n*1) The vector of response variable.}

\item{K_int}{(matrix, n*n) The kernel matrix to be tested.}

\item{y_fixed}{(vector of length n) Estimated fixed effect of the
response.}

\item{sigma2_hat}{(numeric) The estimated noise of the fixed effect.}

\item{tau_hat}{(numeric) The estimated noise of the kernel effect.}

\item{K_0}{(matrix, n*n) Estimated ensemble kernel matrix.}
}
\value{
\item{test_stat}{(numeric) The computed test statistic.}
}
\description{
Compute score test statistics.
}
\details{
The test statistic is distributed as a scaled Chi-squared distribution.
}
\references{
Arnab Maity and Xihong Lin. Powerful tests for detecting a gene
effect in the presence of possible gene-gene interactions using garrote
kernel machines. December 2011.
}
\author{
Wenying Deng
}
\keyword{internal}
