% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exports.R
\docType{methods}
\name{max_entries}
\alias{max_entries}
\alias{max}
\alias{max.Expression}
\title{Maximum}
\usage{
max_entries(x, axis = NA_real_)

\method{max}{Expression}(..., na.rm = FALSE)
}
\arguments{
\item{x}{An \linkS4class{Expression}, vector, or matrix.}

\item{axis}{(Optional) The dimension across which to apply the function: \code{1} indicates rows, \code{2} indicates columns, and \code{NA} indicates rows and columns. The default is \code{NA}.}

\item{...}{Numeric scalar, vector, matrix, or \linkS4class{Expression} objects.}

\item{na.rm}{(Unimplemented) A logical value indicating whether missing values should be removed.}
}
\value{
An \linkS4class{Expression} representing the maximum of the input.
}
\description{
The maximum of an expression.
}
\examples{
x <- Variable(2)
val <- matrix(c(-5,-10))
prob <- Problem(Minimize(max_entries(x)), list(x == val))
result <- solve(prob)
result$value

A <- Variable(2,2)
val <- rbind(c(-5,2), c(-3,1))
prob <- Problem(Minimize(max_entries(A, axis = 1)[2,1]), list(A == val))
result <- solve(prob)
result$value
}
