% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expressions.R, R/affine.R
\docType{methods}
\name{\%*\%,Expression,Expression-method}
\alias{\%*\%,Expression,Expression-method}
\alias{\%*\%,Expression,ConstVal-method}
\alias{\%*\%,ConstVal,Expression-method}
\alias{MulExpression-class}
\alias{MulExpression}
\alias{validate_args,MulExpression-method}
\alias{size_from_args,MulExpression-method}
\alias{is_incr,MulExpression-method}
\alias{is_decr,MulExpression-method}
\alias{graph_implementation,MulExpression-method}
\title{The MulExpression class.}
\usage{
\S4method{\%*\%}{Expression,Expression}(x, y)

\S4method{\%*\%}{Expression,ConstVal}(x, y)

\S4method{\%*\%}{ConstVal,Expression}(x, y)

\S4method{validate_args}{MulExpression}(object)

\S4method{size_from_args}{MulExpression}(object)

\S4method{is_incr}{MulExpression}(object, idx)

\S4method{is_decr}{MulExpression}(object, idx)

\S4method{graph_implementation}{MulExpression}(object, arg_objs, size,
  data = NA_real_)
}
\arguments{
\item{x, y}{The \linkS4class{Expression} objects or numeric constants to multiply.}

\item{object}{A \linkS4class{MulExpression} object.}

\item{idx}{An index into the atom.}

\item{arg_objs}{A list of linear expressions for each argument.}

\item{size}{A vector with two elements representing the size of the resulting expression.}

\item{data}{A list of additional data required by the atom.}
}
\description{
This class represents the matrix product of two linear expressions.
See \linkS4class{MulElemwise} for the elementwise product.
}
\section{Methods (by generic)}{
\itemize{
\item \code{validate_args}: Check the dimensions.

\item \code{size_from_args}: The size of the expression.

\item \code{is_incr}: Is the left-hand expression positive?

\item \code{is_decr}: Is the left-hand expression negative?

\item \code{graph_implementation}: The graph implementation of the expression.
}}

\seealso{
\linkS4class{MulElemwise}
}
