% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reduction_solvers.R
\docType{class}
\name{ConstantSolver-class}
\alias{ConstantSolver-class}
\alias{ConstantSolver}
\alias{mip_capable,ConstantSolver-method}
\alias{accepts,ConstantSolver,Problem-method}
\alias{perform,ConstantSolver,Problem-method}
\alias{invert,ConstantSolver,Solution,list-method}
\alias{name,ConstantSolver-method}
\alias{import_solver,ConstantSolver-method}
\alias{is_installed,ConstantSolver-method}
\alias{solve_via_data,ConstantSolver-method}
\alias{reduction_solve,ConstantSolver,ANY-method}
\title{The ConstantSolver class.}
\usage{
\S4method{mip_capable}{ConstantSolver}(solver)

\S4method{accepts}{ConstantSolver,Problem}(object, problem)

\S4method{perform}{ConstantSolver,Problem}(object, problem)

\S4method{invert}{ConstantSolver,Solution,list}(object, solution, inverse_data)

\S4method{name}{ConstantSolver}(x)

\S4method{import_solver}{ConstantSolver}(solver)

\S4method{is_installed}{ConstantSolver}(solver)

\S4method{solve_via_data}{ConstantSolver}(
  object,
  data,
  warm_start,
  verbose,
  feastol,
  reltol,
  abstol,
  num_iter,
  solver_opts,
  solver_cache
)

\S4method{reduction_solve}{ConstantSolver,ANY}(object, problem, warm_start, verbose, solver_opts)
}
\arguments{
\item{solver, object, x}{A \linkS4class{ConstantSolver} object.}

\item{problem}{A \linkS4class{Problem} object.}

\item{solution}{A \linkS4class{Solution} object to invert.}

\item{inverse_data}{A list containing data necessary for the inversion.}

\item{data}{Data for the solver.}

\item{warm_start}{A boolean of whether to warm start the solver.}

\item{verbose}{A boolean of whether to enable solver verbosity.}

\item{feastol}{The feasible tolerance.}

\item{reltol}{The relative tolerance.}

\item{abstol}{The absolute tolerance.}

\item{num_iter}{The maximum number of iterations.}

\item{solver_opts}{A list of Solver specific options}

\item{solver_cache}{Cache for the solver.}
}
\description{
The ConstantSolver class.
}
\section{Methods (by generic)}{
\itemize{
\item \code{mip_capable(ConstantSolver)}: Can the solver handle mixed-integer programs?

\item \code{accepts(object = ConstantSolver, problem = Problem)}: Is the solver capable of solving the problem?

\item \code{perform(object = ConstantSolver, problem = Problem)}: Returns a list of the ConstantSolver, Problem, and an empty list.

\item \code{invert(object = ConstantSolver, solution = Solution, inverse_data = list)}: Returns the solution.

\item \code{name(ConstantSolver)}: Returns the name of the solver.

\item \code{import_solver(ConstantSolver)}: Imports the solver.

\item \code{is_installed(ConstantSolver)}: Is the solver installed?

\item \code{solve_via_data(ConstantSolver)}: Solve a problem represented by data returned from apply.

\item \code{reduction_solve(object = ConstantSolver, problem = ANY)}: Solve the problem and return a \linkS4class{Solution} object.

}}
