% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atoms.R
\docType{class}
\name{Pnorm-class}
\alias{Pnorm-class}
\alias{.Pnorm}
\alias{Pnorm}
\alias{allow_complex,Pnorm-method}
\alias{to_numeric,Pnorm-method}
\alias{validate_args,Pnorm-method}
\alias{sign_from_args,Pnorm-method}
\alias{is_atom_convex,Pnorm-method}
\alias{is_atom_concave,Pnorm-method}
\alias{is_atom_log_log_convex,Pnorm-method}
\alias{is_atom_log_log_concave,Pnorm-method}
\alias{is_incr,Pnorm-method}
\alias{is_decr,Pnorm-method}
\alias{is_pwl,Pnorm-method}
\alias{get_data,Pnorm-method}
\alias{name,Pnorm-method}
\alias{.domain,Pnorm-method}
\alias{.grad,Pnorm-method}
\alias{.column_grad,Pnorm-method}
\title{The Pnorm class.}
\usage{
Pnorm(x, p = 2, axis = NA_real_, keepdims = FALSE, max_denom = 1024)

\S4method{allow_complex}{Pnorm}(object)

\S4method{to_numeric}{Pnorm}(object, values)

\S4method{validate_args}{Pnorm}(object)

\S4method{sign_from_args}{Pnorm}(object)

\S4method{is_atom_convex}{Pnorm}(object)

\S4method{is_atom_concave}{Pnorm}(object)

\S4method{is_atom_log_log_convex}{Pnorm}(object)

\S4method{is_atom_log_log_concave}{Pnorm}(object)

\S4method{is_incr}{Pnorm}(object, idx)

\S4method{is_decr}{Pnorm}(object, idx)

\S4method{is_pwl}{Pnorm}(object)

\S4method{get_data}{Pnorm}(object)

\S4method{name}{Pnorm}(x)

\S4method{.domain}{Pnorm}(object)

\S4method{.grad}{Pnorm}(object, values)

\S4method{.column_grad}{Pnorm}(object, value)
}
\arguments{
\item{x}{An \linkS4class{Expression} representing a vector or matrix.}

\item{p}{A number greater than or equal to 1, or equal to positive infinity.}

\item{axis}{(Optional) The dimension across which to apply the function: \code{1} indicates rows, \code{2} indicates columns, and \code{NA} indicates rows and columns. The default is \code{NA}.}

\item{keepdims}{(Optional) Should dimensions be maintained when applying the atom along an axis? If \code{FALSE}, result will be collapsed into an \eqn{n x 1} column vector. The default is \code{FALSE}.}

\item{max_denom}{(Optional) The maximum denominator considered in forming a rational approximation for \eqn{p}. The default is 1024.}

\item{object}{A \linkS4class{Pnorm} object.}

\item{values}{A list of numeric values for the arguments}

\item{idx}{An index into the atom.}

\item{value}{A numeric value}
}
\description{
This class represents the vector p-norm.
}
\details{
If given a matrix variable, \code{Pnorm} will treat it as a vector and compute the p-norm of the concatenated columns.

For \eqn{p \geq 1}, the p-norm is given by \deqn{\|x\|_p = \left(\sum_{i=1}^n |x_i|^p\right)^{1/p}} with domain \eqn{x \in \mathbf{R}^n}.
For \eqn{p < 1, p\neq 0}, the p-norm is given by \deqn{\|x\|_p = \left(\sum_{i=1}^n x_i^p\right)^{1/p}} with domain \eqn{x \in \mathbf{R}^n_+}.

\itemize{
   \item Note that the "p-norm" is actually a \strong{norm} only when \eqn{p \geq 1} or \eqn{p = +\infty}. For these cases, it is convex.
   \item The expression is undefined when \eqn{p = 0}.
   \item Otherwise, when \eqn{p < 1}, the expression is concave, but not a true norm.
}
}
\section{Methods (by generic)}{
\itemize{
\item \code{allow_complex(Pnorm)}: Does the atom handle complex numbers?

\item \code{to_numeric(Pnorm)}: The p-norm of \code{x}.

\item \code{validate_args(Pnorm)}: Check that the arguments are valid.

\item \code{sign_from_args(Pnorm)}: The atom is positive.

\item \code{is_atom_convex(Pnorm)}: The atom is convex if \eqn{p \geq 1}.

\item \code{is_atom_concave(Pnorm)}: The atom is concave if \eqn{p < 1}.

\item \code{is_atom_log_log_convex(Pnorm)}: Is the atom log-log convex?

\item \code{is_atom_log_log_concave(Pnorm)}: Is the atom log-log concave?

\item \code{is_incr(Pnorm)}: The atom is weakly increasing if \eqn{p < 1} or \eqn{p > 1} and \code{x} is positive.

\item \code{is_decr(Pnorm)}: The atom is weakly decreasing if \eqn{p > 1} and \code{x} is negative.

\item \code{is_pwl(Pnorm)}: The atom is not piecewise linear unless \eqn{p = 1} or \eqn{p = \infty}.

\item \code{get_data(Pnorm)}: Returns \code{list(p, axis)}.

\item \code{name(Pnorm)}: The name and arguments of the atom.

\item \code{.domain(Pnorm)}: Returns constraints describing the domain of the node

\item \code{.grad(Pnorm)}: Gives the (sub/super)gradient of the atom w.r.t. each variable

\item \code{.column_grad(Pnorm)}: Gives the (sub/super)gradient of the atom w.r.t. each column variable

}}
\section{Slots}{

\describe{
\item{\code{x}}{An \linkS4class{Expression} representing a vector or matrix.}

\item{\code{p}}{A number greater than or equal to 1, or equal to positive infinity.}

\item{\code{max_denom}}{The maximum denominator considered in forming a rational approximation for \eqn{p}.}

\item{\code{axis}}{(Optional) The dimension across which to apply the function: \code{1} indicates rows, \code{2} indicates columns, and \code{NA} indicates rows and columns. The default is \code{NA}.}

\item{\code{keepdims}}{(Optional) Should dimensions be maintained when applying the atom along an axis? If \code{FALSE}, result will be collapsed into an \eqn{n x 1} column vector. The default is \code{FALSE}.}

\item{\code{.approx_error}}{(Internal) The absolute difference between \eqn{p} and its rational approximation.}

\item{\code{.original_p}}{(Internal) The original input \eqn{p}.}
}}

