% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exports.R
\docType{methods}
\name{lambda_sum_smallest}
\alias{lambda_sum_smallest}
\title{Sum of Smallest Eigenvalues}
\usage{
lambda_sum_smallest(A, k)
}
\arguments{
\item{A}{An \linkS4class{Expression} or matrix.}

\item{k}{The number of eigenvalues to sum over.}
}
\value{
An \linkS4class{Expression} representing the sum of the smallest \code{k} eigenvalues of the input.
}
\description{
The sum of the smallest \eqn{k} eigenvalues of a matrix.
}
\examples{
C <- Variable(3,3)
val <- cbind(c(1,2,3), c(2,4,5), c(3,5,6))
prob <- Problem(Maximize(lambda_sum_smallest(C,2)), list(C == val))
result <- solve(prob)
result$value
result$getValue(C)
}
