% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/affine.R
\docType{class}
\name{CumSum-class}
\alias{CumSum-class}
\alias{.CumSum}
\alias{CumSum}
\alias{to_numeric,CumSum-method}
\alias{dim_from_args,CumSum-method}
\alias{get_data,CumSum-method}
\alias{.grad,CumSum-method}
\alias{graph_implementation,CumSum-method}
\title{The CumSum class.}
\usage{
CumSum(expr, axis = 2)

\S4method{to_numeric}{CumSum}(object, values)

\S4method{dim_from_args}{CumSum}(object)

\S4method{get_data}{CumSum}(object)

\S4method{.grad}{CumSum}(object, values)

\S4method{graph_implementation}{CumSum}(object, arg_objs, dim, data = NA_real_)
}
\arguments{
\item{expr}{An \linkS4class{Expression} to be summed.}

\item{axis}{(Optional) The dimension across which to apply the function: \code{1} indicates rows, and \code{2} indicates columns. The default is \code{2}.}

\item{object}{A \linkS4class{CumSum} object.}

\item{values}{A list of numeric values for the arguments}

\item{arg_objs}{A list of linear expressions for each argument.}

\item{dim}{A vector representing the dimensions of the resulting expression.}

\item{data}{A list of additional data required by the atom.}
}
\description{
This class represents the cumulative sum.
}
\section{Methods (by generic)}{
\itemize{
\item \code{to_numeric}: The cumulative sum of the values along the specified axis.

\item \code{dim_from_args}: The dimensions of the atom.

\item \code{get_data}: Returns the axis along which the cumulative sum is taken.

\item \code{.grad}: Gives the (sub/super)gradient of the atom w.r.t. each variable

\item \code{graph_implementation}: The graph implementation of the atom.
}}

\section{Slots}{

\describe{
\item{\code{expr}}{An \linkS4class{Expression} to be summed.}

\item{\code{axis}}{(Optional) The dimension across which to apply the function: \code{1} indicates rows, and \code{2} indicates columns. The default is \code{2}.}
}}

