% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.cve}
\alias{summary.cve}
\title{Prints summary statistics of the \eqn{L} \code{cve} component.}
\usage{
\method{summary}{cve}(object, ...)
}
\arguments{
\item{object}{an object of class \code{"cve"}, usually, a result of a call to
\code{\link{cve}} or \code{\link{cve.call}}.}

\item{...}{ignored.}
}
\value{
No return value, prints human readable summary.
}
\description{
Prints a summary statistics of the \code{L} component of a \code{cve} object #' for \code{k = min.dim, ..., max.dim}.
}
\examples{
# create B for simulation
B <- rep(1, 5) / sqrt(5)

set.seed(21)
# create predictor data x ~ N(0, I_p)
x <- matrix(rnorm(500), 100)

# simulate response variable
#    y = f(B'x) + err
# with f(x1) = x1 and err ~ N(0, 0.25^2)
y <- x \%*\% B + 0.25 * rnorm(100)

# calculate cve for unknown reduction dimension.
cve.obj.simple <- cve(y ~ x)

summary(cve.obj.simple)

}
