% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UniformDesignMatrix.R
\name{CorrelatedDesignMatrix}
\alias{CorrelatedDesignMatrix}
\title{Create a design matrix of categorical variables with correlated columns.}
\usage{
CorrelatedDesignMatrix(n, cov_mat, c)
}
\arguments{
\item{n}{Number of observations}

\item{cov_mat}{p x p covariance matrix. Controls correlations of pairs of marginally U[0,1] random variables that are subsequently binned to assign categories for each variable}

\item{c}{Number of categories within each variable}
}
\value{
A data frame of categorical (factor) variables.
}
\description{
Function for use in simulations. Created design matrix of categorical variables with correlated columns
}
\examples{
# Generate matrix of marginal U[0,1] variables, 0.5 pairwise correlation, that are
# discretised into factor variables
cov_mat = 0.5 * diag(10) + 0.5 * matrix(1, 10, 10)
x = CorrelatedDesignMatrix(100, cov_mat, 8)

}
