% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scope.R
\name{scope}
\alias{scope}
\title{Compute solution for SCOPE linear models.}
\usage{
scope(
  x,
  y,
  gamma = 8,
  lambda = NULL,
  nlambda = 100,
  lambda_min_ratio = 0.01,
  nfolds = 5,
  include_intercept = TRUE,
  return_full_beta = FALSE,
  max_iter = 1000,
  early_stopping = ifelse(pshrink > 1, TRUE, FALSE),
  early_stopping_rounds = 20,
  early_stopping_criterion = "AIC",
  noise_variance = NULL,
  terminate_eps = 1e-07,
  silent = TRUE,
  only_cross_validate = FALSE,
  grid_safe = 10,
  block_order = NULL,
  fold_assignment = NULL
)
}
\arguments{
\item{x}{Data frame of covariates: Can include a mix of continuous and categorical variables (no scaling of continuous covariates is performed within the program).
By default an intercept will be added to the linear part; see include_intercept}

\item{y}{Response vector of length n}

\item{gamma}{Concavity parameter in MCP; see Zhang (2010) Nearly unbiased estimation with minimax concave penalty}

\item{lambda}{If NULL default sequence will be generated. Matrix of values (p_categorical times nlambda) of penalty parameter lambda. Must be non-negative and each row decreasing. Note that if lambda = 0 then no shrinkage will occur.}

\item{nlambda}{Length of default sequence of lambda values generated if lambda = NULL}

\item{lambda_min_ratio}{Ratio of largest to smallest value on default sequence of lambda values}

\item{nfolds}{Number of folds in cross-validation. If nfolds = 1, no cross-validation is performed}

\item{include_intercept}{If TRUE, a column of 1s will be added to the (continuous) design matrix}

\item{return_full_beta}{If TRUE with cross-validation, the entire solution path will be returned instead of just the optimal point}

\item{max_iter}{Maximum number of iterations at each point on the lambda path}

\item{early_stopping}{Early stopping based on information criterion. By default is TRUE if there are more than 1 categorical variables}

\item{early_stopping_rounds}{Number of iterations that information criterion must have not decreased for to terminate}

\item{early_stopping_criterion}{If "AIC", Akaike Information Criterion is used for early stopping. Otherwise if a positive number is given, modified Bayes Information Criterion is used with this integer as the parameter (CITE)}

\item{noise_variance}{If noise variance is known, this will be used for scaling the default values of lambda. Otherwise this will be scaled automatically}

\item{terminate_eps}{Epsilon for convergence criterion, is multiplied by null deviance to get terminate criterion for objective value}

\item{silent}{If FALSE then progress updates will be printed as solutions are computed. Useful for tuning and diagnosing convergence issues.}

\item{only_cross_validate}{If TRUE then cross-validation scores for each value of lambda will be returned, but not the estimates themselves}

\item{grid_safe}{As the automatically generated sequence of lambda values is adjusted during the first fold but fixed thereafter. For subsequent folds, this sets computation to begin at a larger value of lambda to ensure that the first solution along the path is zero so as to maintain the advantages of the pathwise approach. This specifies how many larger values of lambda should be used}

\item{block_order}{By default the order in block coordinate descent is randomly sampled. Alternatively a permutation vector can be included here}

\item{fold_assignment}{By default the assignments for cross-validation are randomly sampled automatically. Alternatively assignments can be included here}
}
\value{
A list of objects. Some may not be returned depending on value of arguments K, simply.cross.validated, return.full.beta.
\itemize{
\item lambda - A matrix of the values of lambda used to compute the solution path. Columns correspond to different points on the path, rows correspond to the
categorical variables. Lambda is scaled depending on the number of categories present in the data.
\item cverrors - Provided nfolds > 1 then the cross-validation error for each point on the grid will be returned
\item beta.full - Contains full solution path. If nfolds > 1 then will only be returned if simply.cross.validated = FALSE and return.full.beta = TRUE.
First object [[ 1 ]] is coefficients of continuous variables, [[ 2 ]] is a list of coefficients for categorical variables
\item beta.best - Contains solution at CV-optimal point. Requires nfolds > 1 to be returned. This must not be NULL in order to use predict.scope. First object [[ 1 ]] is
coefficients of continuous variables, [[ 2 ]] is a list of coefficients for categorical variables
\item fold.assign - Contains fold assignments for cross-validation
}
}
\description{
Computes solution for SCOPE linear models. Performs K-fold cross-validation for regularisation parameter lambda and can incorporate
both linear and categorical (including logical) variables.
}
\examples{
set.seed(1)
x = UniformDesignMatrix(100, 5, 8) 
y = (as.integer(x[ , 1 ]) < 5) + (as.integer(x[ , 2 ]) < 5)  + rnorm(100)
scope_mod = scope(x, y)
x_new = UniformDesignMatrix (10, 5, 8)
predict(scope_mod, x_new)
}
