% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache_set.R
\name{catr_set_cache_dir}
\alias{catr_set_cache_dir}
\title{Set your \strong{CatastRo} cache dir}
\usage{
catr_set_cache_dir(
  cache_dir,
  overwrite = FALSE,
  install = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{cache_dir}{A path to a cache directory. On missing value the function
would store the cached files on a temporary dir (See \code{\link[base:tempfile]{base::tempdir()}}).}

\item{overwrite}{If this is set to \code{TRUE}, it will overwrite an existing
\code{CATASTROESP_CACHE_DIR} that you already have in local machine.}

\item{install}{if \code{TRUE}, will install the key in your local machine for
use in future sessions.  Defaults to \code{FALSE.} If \code{cache_dir} is \code{FALSE}
this parameter is set to \code{FALSE} automatically.}

\item{verbose}{Logical, displays information. Useful for debugging,
default is \code{FALSE}.}
}
\value{
An (invisible) character with the path to your \code{cache_dir}.
}
\description{
This function will store your \code{cache_dir} path on your local machine and
would load it for future sessions. Type \code{Sys.getenv("CATASTROESP_CACHE_DIR")}
to find your cached path.

Alternatively, you can store the \code{cache_dir} manually with the following
options:
\itemize{
\item Run \code{Sys.setenv(CATASTROESP_CACHE_DIR = "cache_dir")}. You would need to
run this command on each session (Similar to \code{install = FALSE}).
\item Write this line on your .Renviron file:
\code{CATASTROESP_CACHE_DIR = "value_for_cache_dir"} (same behavior than
\code{install = TRUE}). This would store your \code{cache_dir} permanently.
}
}
\section{About caching}{
Sometimes cached files may be corrupt. On that case, try re-downloading
the data setting \code{update_cache = TRUE}.

If you experience any problem on download, try to download the
corresponding file by any other method and save it on your
\code{cache_dir}. Use the option \code{verbose = TRUE} for debugging the API query.
}

\examples{

# Don't run this! It would modify your current state
\dontrun{
catr_set_cache_dir(verbose = TRUE)
}

Sys.getenv("CATASTROESP_CACHE_DIR")
}
\seealso{
\code{\link[rappdirs:user_data_dir]{rappdirs::user_config_dir()}}

Other cache utilities: 
\code{\link{catr_clear_cache}()}
}
\concept{cache utilities}
