% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/util.R
\name{synthetizeCausalEffect}
\alias{synthetizeCausalEffect}
\title{Computes Average Causal Effects by Covariate Adjustment in Binary Models using a Given Causal Model}
\usage{
synthetizeCausalEffect(problem)
}
\arguments{
\item{problem}{a \code{\link{cfx}} problem instance for the ACE of a given treatment \eqn{X} on a given outcome \eqn{Y}.
               This problem instance should have a fully specified causal model, including a graph and conditional
               probability tables. It must also be small enough so that the joint probability must have been
               pre-computed.}
}
\value{
A list containing three different types of estimand:
  \item{\code{effect_real}}{the true ACE.}
  \item{\code{effect_naive}}{the result of a naive adjustment using all of the observed covariates.}
  \item{\code{effect_naive2}}{the result of a naive adjustment using no covariates.}
}
\description{
Computes the average causal effect (ACE) of a given treatment variable \eqn{X} on a given
outcome \eqn{Y} for the models generated by \code{\link{simulateWitnessModel}}. This assumes
the synthetic models are small enough, as adjustment is done by brute force calculation.
}
\details{
The algorithm implemented is a naive one. When creating the \code{cfx} object, field \code{num_v_max} must be
large enough so that the joint distribution is computed in advance. Only for relatively small models (approximately 20
variables in total) this will be feasible.
}
\examples{
## Generate a synthetic problem
problem <- simulateWitnessModel(p = 4, q = 4, par_max = 3, M = 1000)

## Idealized case: suppose we know the true distribution,
## get "exact" ACE estimands for different adjustment sets
sol_pop <- covsearch(problem, pop_solve = TRUE)
effect_pop <- synthetizeCausalEffect(problem)
cat(sprintf(
  "ACE (true) = \%1.2f\\nACE (adjusting for all) = \%1.2f\\nACE (adjusting for nothing) = \%1.2f\\n",
   effect_pop$effect_real, effect_pop$effect_naive, effect_pop$effect_naive2))
}

