% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query_helpers.R
\name{interacts}
\alias{interacts}
\title{Make statement for any interaction}
\usage{
interacts(X1, X2, Y)
}
\arguments{
\item{X1}{A character. The quoted name of the input node 1.}

\item{X2}{A character. The quoted name of the input node 2.}

\item{Y}{A character. The quoted name of the outcome node.}
}
\value{
A character statement of class \code{statement}
}
\description{
Generate a statement for X1, X1 interact in the production of Y
}
\examples{
\donttest{
interacts('A', 'B', 'W')
get_query_types(model = make_model('X-> Y <- W'),
         query = interacts('X', 'W', 'Y'), map = "causal_type")
}
}
\seealso{
Other statements: 
\code{\link{complements}()},
\code{\link{decreasing}()},
\code{\link{increasing}()},
\code{\link{non_decreasing}()},
\code{\link{non_increasing}()},
\code{\link{substitutes}()},
\code{\link{te}()}
}
\concept{statements}
