% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_helpers.R
\name{observe_data}
\alias{observe_data}
\title{Observe data, given a strategy}
\usage{
observe_data(
  complete_data,
  observed = NULL,
  nodes_to_observe = NULL,
  prob = 1,
  m = NULL,
  subset = TRUE
)
}
\arguments{
\item{complete_data}{A \code{data.frame}. Data observed and unobserved.}

\item{observed}{A \code{data.frame}. Data observed.}

\item{nodes_to_observe}{A list. Nodes to observe.}

\item{prob}{A scalar. Observation probability.}

\item{m}{A integer. Number of units to observe; if specified, \code{m}
overrides \code{prob}.}

\item{subset}{A character.  Logical statement that can be applied to rows
of complete data. For instance observation for some nodes might depend on
observed values of other nodes; or observation may only be sought if
data not already observed!}
}
\value{
A \code{data.frame} with logical values indicating which nodes
  to observe in each row of `complete_data`.
}
\description{
Observe data, given a strategy
}
\examples{
model <- make_model("X -> Y")
df <- make_data(model, n = 8)
# Observe X values only
CausalQueries:::observe_data(complete_data = df, nodes_to_observe = "X")
# Observe half the Y values for cases with observed X = 1
CausalQueries:::observe_data(complete_data = df,
     observed = CausalQueries:::observe_data(complete_data = df, nodes_to_observe = "X"),
     nodes_to_observe = "Y", prob = .5,
     subset = "X==1")
}
\seealso{
Other data_generation: 
\code{\link{data_helpers}},
\code{\link{get_all_data_types}()},
\code{\link{make_data_single}()}
}
\concept{data_generation}
\keyword{internal}
