% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/execute_mmdlModel.R
\name{execute_mmdlModel}
\alias{execute_mmdlModel}
\title{Run Model Executor from Pirana}
\usage{
execute_mmdlModel(metamodelFile, hostsfile)
}
\arguments{
\item{metamodelFile}{Path to existing metamodel file \code{.mmdl}.}

\item{hostsfile}{Path to hosts definitions file \code{.json}. Note,
this file is automatically generated by Pirana given the user provided
NLME host setup in Pirana settings.}
}
\value{
Deploys a Shiny app to execute a \code{Certara.RsNLME} model. Returns \code{NULL} if assigned to an object.
}
\description{
Used by Pirana internally to launch the Model Executor Shiny GUI.
}
\examples{
if (interactive()) {
# Get existing mmdl file
mmdl_file <- system.file("vignettesdata/OneCpt_IVInfusion.mmdl",
  package = "Certara.RsNLME")

# Create hosts file json. Note, hosts file is automatically created by Pirana.
hosts_file <- tempfile(pattern = "hosts", fileext = ".json")
jsonlite::write_json(
  list(
    list(profile_name = "examplehost", cores_number = 1, os = "Windows", parallel_mode="None")),
  auto_unbox = TRUE, 
  path = hosts_file
  ) 
execute_mmdlModel(
  mmdl_file, 
  hosts_file
  )
}
}
