\name{hmapSpectra}
\alias{hmapSpectra}

\title{
Create a Seriated Heat Map Comparing Samples and Spectral Data for a Spectra Object
}
\description{
Creates a heat map with marginal dendrograms using seriation procedures.  Very briefly, the samples that are most like each other occur in one corner, and the frequencies that are most informative with respect to the samples are in that corner as well. This is achieved by using hierchical cluster analysis and then re-ordering the clusters in a coordinated way across each dimension.  See the reference.
}
\usage{
hmapSpectra(spectra, no.col = 5, cexRow = 1, cexCol = 1, ...)
}

\arguments{
  \item{spectra}{ An object of S3 class \code{\link{Spectra}}.}

  \item{no.col}{
The number of colors (levels) to use in the heat map.  Maximum of 9, generated by \code{RColorBrewer}.
}
  \item{cexRow}{
Scale factor for the row labels.
}
  \item{cexCol}{
Scale factor for the column labels.
}
  \item{\dots}{
Additional arguments to be passed downstream.
}
}
\value{
None.  Side effect is a plot.
}
\references{
\url{https://github.com/bryanhanson/ChemoSpec}

}

\author{
Bryan A. Hanson, DePauw University. \email{hanson@depauw.edu}
}

\seealso{
\code{\link[seriation]{hmap}} which will get you to the package (there is no package index page); the vignette is a good place to begin (\code{vignette("seriation")}).
}

\examples{
data(SrE.IR)
# remove noisy, uninteresting region:
newIR <- removeFreq(SrE.IR, rem.freq =
SrE.IR$freq > 1800 & SrE.IR$freq < 2500)
# now make the heat map:
myt <- expression(italic(S.)~italic(repens)~IR~Spectra)
hmapSpectra(newIR, title = myt, t.pos = c(0.5, 0.5, 0.5),
cexRow = 0.5, cexCol = 0.1, no.col = 9)
}
\keyword{ multivariate }

