% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSpectra2D.R
\name{plotSpectra2D}
\alias{plotSpectra2D}
\title{Plot a Spectra2D Object}
\usage{
plotSpectra2D(spectra, which = 1, lvls = NULL, cols = NULL,
  showNA = TRUE, showGrid = FALSE, ...)
}
\arguments{
\item{spectra}{An object of S3 class \code{\link{Spectra2D}}.}

\item{which}{An integer specifying which spectrum to plot.  May be a vector.}

\item{lvls}{A numeric vector specifying the levels at which to compute contours.
If \code{NULL}, values are computed using \code{\link{calcLvls}}.  If
argument \code{which} gives more than one spectrum to plot, then \code{lvls}
must be a list of levels of \code{length(which)}.}

\item{cols}{A vector of valid color designations.  If provided, must be of the
the same length as \code{lvls} (i.e. each contour is a particular color).
If \code{NULL}, defaults to using a scheme of up to nine values
running from blue (low) to red (high), centered on green (zero).  If
argument \code{which} gives more than one spectrum to plot, then \code{cols}
must be a list of colors of \code{length(which)}.}

\item{showNA}{Logical. Should the locations of peaks removed by \code{\link{removePeaks2D}}
be shown?  If present, these are shown by a gray line at each frequency.}

\item{showGrid}{Logical. If TRUE, show a dotted gray line at each tick mark.}

\item{\ldots}{Additional parameters to be passed to the plotting routines.}
}
\value{
Side effect is a plot.
}
\description{
Plots a 2D spectrum stored in a \code{\link{Spectra2D}} object.
This is primarily for inspection and for preparation of final plots.
If you need to do extensive exploration, you should probably go back
to the spectrometer.
}
\section{Warning}{

One cannot remove frequencies from the interior of a 2D NMR data set and expect to get a meaningful
contour plot, because doing so puts unrelated peaks adjacent in the data set.
This would lead to contours being drawn that don't exist in the original data set.
This function will check for missing frequencies and stop if any are found.
}

\section{Scale}{

You can view the color scale for the plot via \code{\link{showScale}}.
}

\section{Levels & Colors}{

The number of levels and colors must match, and they are used 1 for 1.  If you
provide \code{n} colors, and no levels, the automatic calculation of levels may return
a number of levels other than \code{n}, in which case the function will override your colors and
assign new colors for the number of levels it computed (with a message).  To get
exactly what you want, specify both levels and colors in equal numbers.  Function
\code{\link{inspectLvls}} can help you choose appropriate levels.
}

\section{Overlaying Spectra}{

If you specify more than one spectrum to plot, e.g. \code{which = c(1,2)}, then
arguments \code{lvls} and \code{cols} must be lists of levels and colors, one list
element for each spectrum to be plotted (if specified at all).  See the examples.
}

\examples{

data(MUD1)
mylvls <- seq(-0.3, 0.3, 0.1)[-4]
plotSpectra2D(MUD1, which = 7, lvls = mylvls,
  main = "MUD1 Sample 7")
plotSpectra2D(MUD1, which = c(1, 6), lvls = list(mylvls, mylvls),
  cols = list(rep("black", 6), rep("red", 6)),
  main = "MUD1 Sample 1 (black) & Sample 6 (red)")

}
\author{
Bryan A. Hanson, DePauw University.
}
\keyword{hplot}
