% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/low_chill.R
\name{lowchill_model}
\alias{lowchill_model}
\title{Low Chill}
\usage{
lowchill_model(x, total = TRUE)
}
\arguments{
\item{x}{Vector containing temperature values (Celsius-degree).}

\item{total}{TRUE Shows the total value of accumulation, FALSE shows the value of chill-unit for each temperature (TRUE is default).}
}
\value{
The function returns values the chill-units for each temperature of vector (Total = FALSE), or returns the chill-units accumulation (Total = TRUE).
}
\description{
Quantifies the chill accumulation by means of converting temperatures to chill-units.
}
\details{
The model is based on chill-units, where 1 chill-unit is when the tree is exposure between 1.8°C and 8°C. When the temperature is above 19.5°C, the chill-unit is -1. The chill-units accumulation is 0 when occurs temperature below -1°C and between 14°C and 17°C.
}
\examples{

x <- rnorm(500, 12, 5)
lowchill_model(x)
lowchill_model(x, FALSE)

}
\references{
GILREATH, Phyllis R. & BUCHANAN, D. W. (1981). Rest Prediction Model for Low-chilling 'Sungold' Nectarine. J. Amer. Soc. Hort. Sci.
}
