/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.graph;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jgrapht.EdgeFactory;
import org.jgrapht.Graph;
import org.jgrapht.graph.AbstractGraph;
import org.jgrapht.util.WeightCombiner;

public class GraphUnion<V, E, G extends Graph<V, E>>
extends AbstractGraph<V, E>
implements Serializable {
    private static final long serialVersionUID = -740199233080172450L;
    private static final String READ_ONLY = "union of graphs is read-only";
    private G g1;
    private G g2;
    private WeightCombiner operator;

    public GraphUnion(G g, G g2, WeightCombiner weightCombiner) {
        if (g == null) {
            throw new NullPointerException("g1 is null");
        }
        if (g2 == null) {
            throw new NullPointerException("g2 is null");
        }
        if (g == g2) {
            throw new IllegalArgumentException("g1 is equal to g2");
        }
        this.g1 = g;
        this.g2 = g2;
        this.operator = weightCombiner;
    }

    public GraphUnion(G g, G g2) {
        this(g, g2, WeightCombiner.SUM);
    }

    @Override
    public Set<E> getAllEdges(V v, V v2) {
        HashSet hashSet = new HashSet();
        if (this.g1.containsVertex(v) && this.g1.containsVertex(v2)) {
            hashSet.addAll(this.g1.getAllEdges(v, v2));
        }
        if (this.g2.containsVertex(v) && this.g2.containsVertex(v2)) {
            hashSet.addAll(this.g2.getAllEdges(v, v2));
        }
        return Collections.unmodifiableSet(hashSet);
    }

    @Override
    public E getEdge(V v, V v2) {
        E e = null;
        if (this.g1.containsVertex(v) && this.g1.containsVertex(v2)) {
            e = this.g1.getEdge(v, v2);
        }
        if (e == null && this.g2.containsVertex(v) && this.g2.containsVertex(v2)) {
            e = this.g2.getEdge(v, v2);
        }
        return e;
    }

    @Override
    public EdgeFactory<V, E> getEdgeFactory() {
        throw new UnsupportedOperationException(READ_ONLY);
    }

    @Override
    public E addEdge(V v, V v2) {
        throw new UnsupportedOperationException(READ_ONLY);
    }

    @Override
    public boolean addEdge(V v, V v2, E e) {
        throw new UnsupportedOperationException(READ_ONLY);
    }

    @Override
    public boolean addVertex(V v) {
        throw new UnsupportedOperationException(READ_ONLY);
    }

    @Override
    public boolean containsEdge(E e) {
        return this.g1.containsEdge(e) || this.g2.containsEdge(e);
    }

    @Override
    public boolean containsVertex(V v) {
        return this.g1.containsVertex(v) || this.g2.containsVertex(v);
    }

    @Override
    public Set<E> edgeSet() {
        HashSet hashSet = new HashSet();
        hashSet.addAll(this.g1.edgeSet());
        hashSet.addAll(this.g2.edgeSet());
        return Collections.unmodifiableSet(hashSet);
    }

    @Override
    public Set<E> edgesOf(V v) {
        HashSet hashSet = new HashSet();
        if (this.g1.containsVertex(v)) {
            hashSet.addAll(this.g1.edgesOf(v));
        }
        if (this.g2.containsVertex(v)) {
            hashSet.addAll(this.g2.edgesOf(v));
        }
        return Collections.unmodifiableSet(hashSet);
    }

    @Override
    public E removeEdge(V v, V v2) {
        throw new UnsupportedOperationException(READ_ONLY);
    }

    @Override
    public boolean removeEdge(E e) {
        throw new UnsupportedOperationException(READ_ONLY);
    }

    @Override
    public boolean removeVertex(V v) {
        throw new UnsupportedOperationException(READ_ONLY);
    }

    @Override
    public Set<V> vertexSet() {
        HashSet hashSet = new HashSet();
        hashSet.addAll(this.g1.vertexSet());
        hashSet.addAll(this.g2.vertexSet());
        return Collections.unmodifiableSet(hashSet);
    }

    @Override
    public V getEdgeSource(E e) {
        if (this.g1.containsEdge(e)) {
            return this.g1.getEdgeSource(e);
        }
        if (this.g2.containsEdge(e)) {
            return this.g2.getEdgeSource(e);
        }
        return null;
    }

    @Override
    public V getEdgeTarget(E e) {
        if (this.g1.containsEdge(e)) {
            return this.g1.getEdgeTarget(e);
        }
        if (this.g2.containsEdge(e)) {
            return this.g2.getEdgeTarget(e);
        }
        return null;
    }

    @Override
    public double getEdgeWeight(E e) {
        if (this.g1.containsEdge(e) && this.g2.containsEdge(e)) {
            return this.operator.combine(this.g1.getEdgeWeight(e), this.g2.getEdgeWeight(e));
        }
        if (this.g1.containsEdge(e)) {
            return this.g1.getEdgeWeight(e);
        }
        if (this.g2.containsEdge(e)) {
            return this.g2.getEdgeWeight(e);
        }
        throw new IllegalArgumentException("no such edge in the union");
    }

    public G getG1() {
        return this.g1;
    }

    public G getG2() {
        return this.g2;
    }
}

