% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wishart.R
\name{rGenInvWishart}
\alias{rGenInvWishart}
\title{Random Generalized Inverse Wishart Distributed Matrices}
\usage{
rGenInvWishart(n, df, Sigma)
}
\arguments{
\item{n}{integer sample size.}

\item{df}{integer parameter, "degrees of freedom", should be less than the
dimension of \code{p}}

\item{Sigma}{positive semi-definite \eqn{p \times p}{(p * p)} "scale" matrix,
the matrix parameter of the distribution.}
}
\value{
a numeric array, say \code{R}, of dimension \eqn{p \times p \times n}{p * p * n},
    where each \code{R[,,i]} is a realization of the pseudo Wishart distribution
    \eqn{W_p(Sigma, df)}.
}
\description{
Generate n random matrices, distributed according
    to the generalized inverse Wishart distribution with parameters
    \code{Sigma} and \code{df}, \eqn{W_p(\Sigma, df)}{W_p(Sigma, df)},
    with sample size \code{df} less than the dimension \code{p}.

    Let \eqn{X_i}, \eqn{i = 1, 2, ..., df} be \code{df}
    observations of a multivariate normal distribution with mean 0 and
    covariance \code{Sigma}. Then \eqn{\sum X_i X_i'} is distributed as a pseudo
    Wishart \eqn{W_p(\Sigma, df)}{W_p(Sigma, df)}. Sometimes this is called a
    singular Wishart distribution, however, that can be confused with the case
    where \eqn{\Sigma}{Sigma} itself is singular. Then the generalized inverse
    Wishart distribution is the natural extension of the inverse Wishart using
    the Moore-Penrose pseudo-inverse. This can generate samples for positive
    semi-definite \eqn{\Sigma}{Sigma} however, a function dedicated to generating
    singular normal random distributions or singular pseudo Wishart distributions
    should be used if that is desired.

    Note there are different ways of parameterizing the Inverse
    Wishart distribution, so check which one you need.
    Here,  If \eqn{X \sim IW_p(\Sigma, \nu)}{X ~ IW_p(Sigma, df)} then
    \eqn{X^{-1} \sim W_p(\Sigma^{-1}, \nu)}{X^{-1} ~ W_p(Sigma^{-1}, df)}.
    Dawid (1981) has a different definition: if
    \eqn{X \sim W_p(\Sigma^{-1}, \nu)}{X ~ W_p(Sigma^{-1}, df)} and
    \eqn{\nu > p - 1}{df > p - 1}, then
    \eqn{X^{-1} = Y \sim IW(\Sigma, \delta)}{X^{-1} = Y ~ IW(Sigma, delta)}, where
    \eqn{\delta = \nu - p + 1}{delta = df - p + 1}.
}
\examples{
set.seed(20181228)
A<-rGenInvWishart(1, 4, 5.0*diag(5))[,,1]
A
# A should be singular
eigen(A)$values
set.seed(20181228)
B <- rPseudoWishart(1, 4, 5.0*diag(5))[,,1]

# A should be a Moore-Penrose pseudo-inverse of B
B
# this should be equal to B
B \%*\% A \%*\% B
# this should be equal to A
A \%*\% B \%*\% A


}
\references{
Diaz-Garcia, Jose A, Ramon Gutierrez Jaimez, and Kanti V Mardia. 1997.
“Wishart and Pseudo-Wishart Distributions and Some Applications to Shape Theory.”
Journal of Multivariate Analysis 63 (1): 73–87. \doi{10.1006/jmva.1997.1689}.

Bodnar, T.,  Mazur, S., Podgórski, K. "Singular inverse Wishart distribution and
its application to portfolio theory", Journal of Multivariate Analysis, Volume 143,
2016, Pages 314-326, ISSN 0047-259X,
\doi{10.1016/j.jmva.2015.09.021}.

Bodnar, T.,  Okhrin, Y., "Properties of the singular, inverse
and generalized inverse partitioned Wishart distributions", Journal of
Multivariate Analysis, Volume 99, Issue 10, 2008,  Pages 2389-2405,
ISSN 0047-259X, \doi{10.1016/j.jmva.2008.02.024}.

Uhlig, Harald. On Singular Wishart and Singular Multivariate Beta Distributions.
Ann. Statist. 22 (1994), no. 1, 395--405. \doi{10.1214/aos/1176325375}.
}
\seealso{
\code{\link{rWishart}}, \code{\link{rInvWishart}},
    and \code{\link{rPseudoWishart}}
}
