% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CompactifyMatrix.R
\name{CompactifyMatrix}
\alias{CompactifyMatrix}
\title{Collapses matrix to unique character state distributions}
\usage{
CompactifyMatrix(CladisticMatrix)
}
\arguments{
\item{CladisticMatrix}{The cladistic matrix in the format imported by \link{ReadMorphNexus}.}
}
\description{
Collapses a cladistic matrix to just unique character state distributions.
}
\details{
Important: not recommended for general use.

This function is intended to make a matrix with redundant character state distributions smaller by collapsing these to single characters and upweighting them accordingly. It is intended purely for use with MRP matrices, but may have some very restricted uses elsewhere.

The function also deletes any characters weighted zero from the matrix.
}
\examples{

# Examine the matrix pre-compactification:
Michaux1989$Matrix_1$Matrix

# Examine the weights pre-compactification:
Michaux1989$Matrix_1$Weights

# Compactify the matrix:
Michaux1989compact <- CompactifyMatrix(Michaux1989)

# Examine the matrix post-compactification:
Michaux1989compact$Matrix_1$Matrix

# Examine the weights post-compactification:
Michaux1989compact$Matrix_1$Weights

}
\seealso{
\link{SafeTaxonomicReduction} and \link{MatrixPruner}
}
\author{
Graeme T. Lloyd \email{graemetlloyd@gmail.com}
}
\keyword{NEXUS}
