% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pathawards.R
\name{pathawards}
\alias{pathawards}
\title{The path of awards for two claimants}
\usage{
pathawards(d, claimants, Rule, col = "red", points = 201)
}
\arguments{
\item{d}{The vector of claims.}

\item{claimants}{The two claimants.}

\item{Rule}{The rule: AA, APRO, CE, CEA, CEL, DT, MO, PIN, PRO, RA, Talmud.}

\item{col}{The color.}

\item{points}{The number of values of the endowment to draw the path.}
}
\value{
The graphical representation of the path of awards of a rule for the given claims and a pair of claimants.
}
\description{
This function returns the graphical representation of the path of awards of a rule for a claims vector and a pair of claimants.
}
\details{
Let \eqn{d\in \mathcal{R}^n}{d}, with \eqn{d\ge 0}, be a vector of claims and
 denote  \eqn{D=\sum_{i=1}^{n} d_i}{D=\sum di} the sum of claims.

The path of awards of a rule \eqn{R} for two claimants \eqn{i} and \eqn{j} is the parametric curve:
\deqn{p(E)=\{(R_i(E,d),R_j(E,d))\in \mathcal{R}^2:\;E\in[0,D]\}.}{p(E)=\{(Ri(E,d),Rj(E,d)): 0\le E \le D\}.}
}
\examples{
d=c(2,4,7,8)
claimants=c(1,2)
Rule=Talmud
pathawards(d,claimants,Rule)
# The path of awards of the concede-and-divide rule
pathawards(c(2,3),c(1,2),CD)
#The path of awards of the DT rule for d=(d1,d2) with d2<2d1
pathawards(c(1,1.5),c(1,2),DT,col="blue",points=1001)
#The path of awards of the DT rule for d=(d1,d2) with d2>2d1
pathawards(c(1,2.5),c(1,2),DT,col="blue",points=1001)
}
\references{
Thomson, W. (2019). How to divide when there isn't enough. From Aristotle, the Talmud, and Maimonides to the axiomatics of resource allocation. Cambridge University Press.
}
\seealso{
\link{pathawards3}, \link{schedrule}, \link{schedrules}, \link{verticalruleplot}
}
