% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indecis_indices.R
\name{pci}
\alias{pci}
\title{Precipitation Concentration Index}
\usage{
pci(data, data_names = NULL, na.rm = FALSE, ...)
}
\arguments{
\item{data}{precipitation}

\item{data_names}{names of each period of time}

\item{na.rm}{logical. Should missing values (including NaN) be removed?}

\item{...}{...}
}
\value{
PCI
}
\description{
Index to evaluate precipitation heterogeneity at a monthly scale. Values <10 (uniform monthly rainfall distribution); values 11-15 (moderate concentration of precipitation); values 16-20 (irregular distribution); and >20 ((high precipitation concentration)
}
\section{Formula}{
 \deqn{PCI = \frac{\sum_{i=1}^{12} P_i ^ 2} {(P_t) ^ 2} * 100}
}

\examples{
data(data_all)
pci(data = data_all$rr)
}
\references{
Oliver, J.E. (1980) Monthly precipitation distribution: a comparative index. Professional Geographer, 32, 300–309
}
