% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DTRIndicator.R
\name{DTRIndicator}
\alias{DTRIndicator}
\title{Diurnal temperature range indicator (DTR) of multidimensional arrays}
\usage{
DTRIndicator(tmax, tmin, ref, by.seasons = TRUE, dates = NULL,
  timedim = NULL, calendar = NULL, ncores = NULL)
}
\arguments{
\item{tmax}{A numeric multidimensional array containing daily maximum temperature.}

\item{tmin}{A numeric multidimensional array containing daily minimum temperature. This array must be the same dimensions as \code{tmax} parameter.}

\item{ref}{An output list from the \code{DTRRef} function with the same dimensions as parameters \code{tmax} and \code{tmin}, except the time dimension, containing the mean diurnal temperature variation for the reference period.}

\item{by.seasons}{If TRUE (by default), the DTR is computed for each season  (December-January-February, March-April-May, June-July-August and September-October-November) seperately. If FALSE is specified, the montly mean DTR is computed.}

\item{dates}{A vector of dates with a calendar attributes. If NULL (by default), the 'time' attributes of parameter 'tmax' and 'tmin' are considered.}

\item{timedim}{An integer number indicating the position of the time dimension in the parameters \code{tmax} and \code{tmin}. If NULL (by default), the dimension called 'time' in parameter \code{tmax} and \code{tmin} is considered as time dimension.}

\item{calendar}{A character indicating the calendar type.}

\item{ncores}{The number of cores to be used when computing the index.}
}
\value{
A list of length 3:
\itemize{
\item\code{$dtr.ref}{An array with the same dimensions as the input \code{data}, but with the time dimension reduce from daily to monthly or seasonal resolution depending on the selected resolution in \code{by.season}.}
\item\code{$year}{A vector of the corresponding years.}
\item\code{$season}{A vector of the seasons or months corresponding to the resolution selected in \code{by.season}}}
}
\description{
This function computes the diurnal temperature indicator, defined as the number of days where the diurnal temperature variation exceeds the vulnerability threshold (defined as the mean(tmax -tmin) + 5 from the reference period).
}
\examples{
##Exmaple with synthetic data:
tmax <- 1 : (2 * 3 * 730 * 1)
dim(tmax) <- c(lon = 2, lat = 3, time = 730, model = 1)
tmin <- (1 : (2 * 3 * 730 * 1)) - 1
dim(tmin) <- c(lon = 2, lat = 3, time = 730, model = 1)
time <- seq(as.POSIXct("1900-01-01 12:00:00", tz = "", format = "\%Y-\%d-\%m \%H:\%M:\%S"), 
           as.POSIXct("1901-31-12 18:00:00", tz = "", format = "\%Y-\%d-\%m \%H:\%M:\%S"), "day")
time <- as.POSIXct(time, tz = "CET")
metadata <- list(time = list(standard_name = 'time', long_name = 'time', 
                            calendar = 'noleap',
                            units = 'days since 1970-01-01 00:00:00', prec = 'double', 
                            dim = list(list(name ='time', unlim = FALSE))))
attr(time, "variables") <- metadata
attr(tmax, 'Variables')$dat1$time <- time
attr(tmax, 'Variables')$common[[2]]$dim[[3]]$len = length(time)
attr(tmax, 'Variables')$common[[2]]$dim[[3]]$vals <- time
attr(tmin, 'Variables')$dat1$time <- time
attr(tmin, 'Variables')$common[[2]]$dim[[3]]$len = length(time)
attr(tmin, 'Variables')$common[[2]]$dim[[3]]$vals <- time
a <- DTRRef(tmax, tmin, by.seasons = FALSE, ncores = NULL)

aa <- DTRIndicator(tmax, tmin, ref = a, by.seasons = FALSE, ncores = NULL)
str(aa)
dim(aa$indicator)
}

