% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster.assign.torus.R
\name{cluster.assign.torus}
\alias{cluster.assign.torus}
\title{Clustering by connected components of ellipsoids}
\usage{
cluster.assign.torus(
  data,
  icp.torus,
  level = 0.1,
  intersection.plot = TRUE,
  coord = NULL
)
}
\arguments{
\item{data}{n x d matrix of toroidal data on \eqn{[0, 2\pi)^d}.}

\item{icp.torus}{an object containing all values to compute the conformity
score, which will be constructed with \code{icp.torus.score}.}

\item{level}{a scalar in \eqn{[0,1]}. Default value
is 0.1.}

\item{intersection.plot}{boolean index. If \code{TRUE}, then plot the
intersections of given ellipsoids. Default is \code{TRUE}.}

\item{coord}{a 2-vector for prespecifing the coordinates.
Default value is \code{NULL} and automatically generates all combinations
of coordinates.}
}
\value{
clustering assignment for data, given \code{icp.torus} objects
}
\description{
\code{cluster.assign.torus} returns clustering assignment for data
  given \code{icp.torus} objects, which can be constructed with
  \code{icp.torus.score}.
}
\examples{
data <- toydata1[, 1:2]
icp.torus <- icp.torus.score(data, method = "kmeans",
                             kmeansfitmethod = "general",
                             param = list(J = 4, concentration = 25))
level <- 0.1

cluster.assign.torus(data, icp.torus, level)
}
\references{
S. Jung, K. Park, and B. Kim (2021),
  "Clustering on the torus by conformal prediction",

  I. Gilitschenski and U. D. Hanebeck,
  "A robust computational test for overlap of
  two arbitrary-dimensional ellipsoids in fault-detection of Kalman filters"
}
\seealso{
\code{\link[ClusTorus]{icp.torus.score}}
}
