% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ECS.R
\name{element_agreement}
\alias{element_agreement}
\title{Element-Wise Average Agreement Between a Set of Clusterings}
\usage{
element_agreement(reference_clustering, clustering_list)
}
\arguments{
\item{reference_clustering}{A Clustering objects for the reference clustering
that each clustering in clustering_list is compared to.}

\item{clustering_list}{A list of Clustering objects used to calculate
the element-wise average agreement}
}
\value{
A vector containing the element-wise average agreement.
}
\description{
Inspect how consistently of a set of clusterings agree with
a reference clustering by calculating their element-wise average agreement.
}
\examples{
reference.clustering = create_clustering(iris$Species)
clustering.list = list()
for (i in 1:20){
  km.res = kmeans(iris[,1:4], 3)$cluster
  clustering.list[[i]] = create_clustering(km.res)
}
element_agreement(reference.clustering, clustering.list)
}
\references{
Gates, A. J., Wood, I. B., Hetrick, W. P., & Ahn, Y. Y. (2019).
Element-centric clustering comparison unifies overlaps and hierarchy.
Scientific reports, 9(1), 1-13. https://doi.org/10.1038/s41598-019-44892-y
}
