% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ECS.R
\name{create_clustering}
\alias{create_clustering}
\alias{create_clustering,numeric-method}
\alias{create_clustering,integer-method}
\alias{create_clustering,character-method}
\alias{create_clustering,factor-method}
\alias{create_clustering,matrix-method}
\alias{create_clustering,Matrix-method}
\alias{create_clustering,hclust-method}
\title{Create Clustering Object}
\usage{
create_clustering(clustering_result, ...)

\S4method{create_clustering}{numeric}(clustering_result, alpha = 0.9)

\S4method{create_clustering}{integer}(clustering_result, alpha = 0.9)

\S4method{create_clustering}{character}(clustering_result, alpha = 0.9)

\S4method{create_clustering}{factor}(clustering_result, alpha = 0.9)

\S4method{create_clustering}{matrix}(
  clustering_result,
  alpha = 0.9,
  ppr_implementation = "prpack",
  row_normalize = TRUE
)

\S4method{create_clustering}{Matrix}(
  clustering_result,
  alpha = 0.9,
  ppr_implementation = "prpack",
  row_normalize = TRUE
)

\S4method{create_clustering}{hclust}(
  clustering_result,
  alpha = 0.9,
  r = 1,
  rescale_path_type = "max",
  ppr_implementation = "prpack",
  dist_rescaled = FALSE
)
}
\arguments{
\item{clustering_result}{The clustering result, either:
\itemize{
\item A numeric/character/factor vector of cluster labels for each element.
\item A samples x clusters matrix/Matrix::Matrix of nonzero membership values.
\item An hclust object.
}}

\item{...}{This argument is not used.}

\item{alpha}{A numeric giving the personalized PageRank damping factor;
1 - alpha is the restart probability for the PPR random walk.}

\item{ppr_implementation}{Choose a implementation for personalized
page-rank calculation:
\itemize{
\item "prpack": use PPR algorithms in igraph.
\item "power_iteration": use power_iteration method.
}}

\item{row_normalize}{Whether to normalize all rows in clustering_result
so they sum to one before calculating ECS. It is recommended to set this to
TRUE, which will lead to slightly different ECS values compared to clusim.}

\item{r}{A numeric hierarchical scaling parameter.}

\item{rescale_path_type}{A string; rescale the hierarchical height by:
\itemize{
\item "max" : the maximum path from the root.
\item "min" : the minimum path form the root.
\item "linkage" : use the linkage distances in the clustering.
}}

\item{dist_rescaled}{A logical: if TRUE, the linkage distances are linearly
rescaled to be in-between 0 and 1.}
}
\value{
A Clustering object.
}
\description{
Creates a Clustering object from the output of a clustering
method.
}
\section{Methods (by class)}{
\itemize{
\item \code{numeric}: Create Clustering Object from Numeric Vector

\item \code{integer}: Create Clustering Object from Integer Vector

\item \code{character}: Create Clustering Object from Character Vector

\item \code{factor}: Create Clustering Object from Factor Vector

\item \code{matrix}: Create Clustering Object from base matrix

\item \code{Matrix}: Create Clustering Object from Matrix::Matrix

\item \code{hclust}: Create Clustering Object from hclust
}}

\keyword{internal}
